var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var subtract_exports = {};
__export(subtract_exports, {
  $subtract: () => $subtract
});
module.exports = __toCommonJS(subtract_exports);
var import_core = require("../../../core");
var import_util = require("../../../util");
const $subtract = (obj, expr, options) => {
  const args = (0, import_core.computeValue)(obj, expr, null, options);
  const errMsg = "$subtract: must resolve to array(2) of numbers/dates";
  (0, import_util.assert)((0, import_util.isArray)(args) && args.length === 2, errMsg);
  const t = args.map(import_util.typeOf).join("|");
  if (t === "date|number") return new Date(+args[0] - +args[1]);
  (0, import_util.assert)(t === "date|date" || t === "number|number", errMsg);
  return +args[0] - +args[1];
};
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  $subtract
});
