var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var dateToString_exports = {};
__export(dateToString_exports, {
  $dateToString: () => $dateToString
});
module.exports = __toCommonJS(dateToString_exports);
var import_core = require("../../../core");
var import_util = require("../../../util");
var import_internal = require("./_internal");
var import_dayOfMonth = require("./dayOfMonth");
var import_dayOfWeek = require("./dayOfWeek");
var import_dayOfYear = require("./dayOfYear");
var import_hour = require("./hour");
var import_isoDayOfWeek = require("./isoDayOfWeek");
var import_isoWeek = require("./isoWeek");
var import_millisecond = require("./millisecond");
var import_minute = require("./minute");
var import_month = require("./month");
var import_second = require("./second");
var import_week = require("./week");
var import_year = require("./year");
const DATE_FUNCTIONS = {
  "%Y": import_year.$year,
  "%G": import_year.$year,
  "%m": import_month.$month,
  "%d": import_dayOfMonth.$dayOfMonth,
  "%H": import_hour.$hour,
  "%M": import_minute.$minute,
  "%S": import_second.$second,
  "%L": import_millisecond.$millisecond,
  "%u": import_isoDayOfWeek.$isoDayOfWeek,
  "%U": import_week.$week,
  "%V": import_isoWeek.$isoWeek,
  "%j": import_dayOfYear.$dayOfYear,
  "%w": (o, e, p) => (0, import_dayOfWeek.$dayOfWeek)(o, e, p) - 1
};
const $dateToString = (obj, expr, options) => {
  const args = (0, import_core.computeValue)(obj, expr, null, options);
  if ((0, import_util.isNil)(args.onNull)) args.onNull = null;
  if ((0, import_util.isNil)(args.date)) return args.onNull;
  const date = (0, import_internal.computeDate)(obj, args.date, options);
  let format = args.format || import_internal.DATE_FORMAT;
  const minuteOffset = (0, import_internal.parseTimezone)(args.timezone);
  const matches = format.match(import_internal.DATE_FORMAT_SYM_RE);
  (0, import_internal.adjustDate)(date, minuteOffset);
  for (let i = 0, len = matches.length; i < len; i++) {
    const formatSpecifier = matches[i];
    (0, import_util.assert)(
      formatSpecifier in import_internal.DATE_SYM_TABLE,
      `$dateToString: invalid format specifier ${formatSpecifier}`
    );
    const { name, padding } = import_internal.DATE_SYM_TABLE[formatSpecifier];
    const fn = DATE_FUNCTIONS[formatSpecifier];
    let value;
    if (fn) {
      value = (0, import_internal.padDigits)(fn(obj, date, options), padding);
    } else {
      switch (name) {
        case "timezone":
          value = (0, import_internal.formatTimezone)(minuteOffset);
          break;
        case "minute_offset":
          value = minuteOffset.toString();
          break;
        case "abbr_month":
        case "full_month": {
          const format2 = name.startsWith("abbr") ? "short" : "long";
          value = date.toLocaleString("en-US", { month: format2 });
          break;
        }
      }
    }
    format = format.replace(formatSpecifier, value);
  }
  return format;
};
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  $dateToString
});
