var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var internal_exports = {};
__export(internal_exports, {
  processOperator: () => processOperator
});
module.exports = __toCommonJS(internal_exports);
var import_core = require("../../../core");
var import_util = require("../../../util");
function processOperator(obj, expr, options, fn, fixedPoints) {
  const fp = {
    undefined: null,
    null: null,
    NaN: NaN,
    Infinity: new Error(),
    "-Infinity": new Error(),
    ...fixedPoints
  };
  const n = (0, import_core.computeValue)(obj, expr, null, options);
  if (n in fp) {
    const res = fp[n];
    const err = res instanceof Error;
    (0, import_util.assert)(!err, `$${fn.name}: value must be in range (-inf,inf)`);
    return !err && res;
  }
  return fn(n);
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  processOperator
});
