var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var internal_exports = {};
__export(internal_exports, {
  MAX_INT: () => MAX_INT,
  MAX_LONG: () => MAX_LONG,
  MIN_INT: () => MIN_INT,
  MIN_LONG: () => MIN_LONG,
  toInteger: () => toInteger
});
module.exports = __toCommonJS(internal_exports);
var import_core = require("../../../core");
var import_util = require("../../../util");
const MAX_INT = 2147483647;
const MIN_INT = -2147483648;
const MAX_LONG = 9007199254740991;
const MIN_LONG = -9007199254740991;
function toInteger(obj, expr, options, min, max) {
  const val = (0, import_core.computeValue)(obj, expr, null, options);
  if (val === true) return 1;
  if (val === false) return 0;
  if ((0, import_util.isNil)(val)) return null;
  if ((0, import_util.isDate)(val)) return val.getTime();
  const n = Number(val);
  (0, import_util.assert)(
    (0, import_util.isNumber)(n) && n >= min && n <= max && (!(0, import_util.isString)(val) || n.toString().indexOf(".") === -1),
    `cannot convert '${val}' to ${max == MAX_INT ? "int" : "long"}`
  );
  return Math.trunc(n);
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  MAX_INT,
  MAX_LONG,
  MIN_INT,
  MIN_LONG,
  toInteger
});
