import { OpType, useOperators } from "../core";
import * as booleanOperators from "../operators/expression/boolean";
import * as comparisonOperators from "../operators/expression/comparison";
import { $limit, $project, $skip, $sort } from "../operators/pipeline";
import * as projectionOperators from "../operators/projection";
import * as queryOperators from "../operators/query";
useOperators(OpType.EXPRESSION, {
  ...booleanOperators,
  ...comparisonOperators
});
useOperators(OpType.PIPELINE, {
  $project,
  $skip,
  $limit,
  $sort
});
useOperators(OpType.PROJECTION, projectionOperators);
useOperators(OpType.QUERY, queryOperators);
