import {
  ComputeOptions,
  computeValue
} from "../../core";
import { Lazy } from "../../lazy";
import { $sort } from "../pipeline/sort";
import { $push } from "./push";
const $bottomN = (collection, expr, options) => {
  const copts = ComputeOptions.init(options);
  const n = computeValue(copts.local.groupId, expr.n, null, copts);
  const result = $sort(Lazy(collection), expr.sortBy, options).value();
  const m = result.length;
  return $push(m <= n ? result : result.slice(m - n), expr.output, copts);
};
export {
  $bottomN
};
