import {
  ComputeOptions,
  computeValue
} from "../../core";
import { assert } from "../../util";
import { $push } from "./push";
const $firstN = (collection, expr, options) => {
  const copts = ComputeOptions.init(options);
  const m = collection.length;
  const n = computeValue(copts?.local?.groupId, expr.n, null, copts);
  assert(n > 0, "$firstN: 'n' must resolve to a positive integer.");
  return $push(
    m <= n ? collection : collection.slice(0, n),
    expr.input,
    options
  );
};
export {
  $firstN
};
