import { assert, compare, isArray, isEmpty, isNil } from "../../util";
import { $push } from "./push";
const $max = (collection, expr, options) => {
  const items = $push(collection, expr, options);
  if (isEmpty(items)) return null;
  assert(isArray(items), "$max: input must resolve to array");
  let max = items[0];
  for (const n of items) {
    if (isNil(n) || isNaN(n)) continue;
    if (compare(n, max) >= 0) max = n;
  }
  return max;
};
export {
  $max
};
