import { assert, compare, isArray, isEmpty, isNil } from "../../util";
import { $push } from "./push";
const $min = (collection, expr, options) => {
  const items = $push(collection, expr, options);
  if (isEmpty(items)) return null;
  assert(isArray(items), "$min: input must resolve to array");
  let min = items[0];
  for (const n of items) {
    if (isNil(n) || isNaN(n)) continue;
    if (compare(n, min) <= 0) min = n;
  }
  return min;
};
export {
  $min
};
