import {
  ComputeOptions,
  computeValue
} from "../../core";
import { Lazy } from "../../lazy";
import { $sort } from "../pipeline/sort";
import { $push } from "./push";
const $topN = (collection, expr, options) => {
  const copts = ComputeOptions.init(options);
  const { n, sortBy } = computeValue(
    copts.local.groupId,
    expr,
    null,
    copts
  );
  const result = $sort(Lazy(collection), sortBy, options).take(n).value();
  return $push(result, expr.output, copts);
};
export {
  $topN
};
