import { computeValue } from "../../../core";
import { assert, isArray, typeOf } from "../../../util";
const $subtract = (obj, expr, options) => {
  const args = computeValue(obj, expr, null, options);
  const errMsg = "$subtract: must resolve to array(2) of numbers/dates";
  assert(isArray(args) && args.length === 2, errMsg);
  const t = args.map(typeOf).join("|");
  if (t === "date|number") return new Date(+args[0] - +args[1]);
  assert(t === "date|date" || t === "number|number", errMsg);
  return +args[0] - +args[1];
};
export {
  $subtract
};
