import { computeValue } from "../../../core";
import { assert, isArray, isNil } from "../../../util";
import { $firstN as __firstN } from "../../accumulator/firstN";
const $firstN = (obj, expr, options) => {
  if (isArray(obj)) return __firstN(obj, expr, options);
  const { input, n } = computeValue(obj, expr, null, options);
  if (isNil(input)) return null;
  assert(isArray(input), "$firstN: 'input' must resolve to an array.");
  return __firstN(input, { n, input: "$$this" }, options);
};
export {
  $firstN
};
