import { computeValue } from "../../../core";
import { assert, isArray, isNil, isNumber } from "../../../util";
function processBitwise(obj, expr, options, compute) {
  assert(isArray(expr), `expression must be an array.`);
  const nums = computeValue(obj, expr, null, options);
  if (nums.some(isNil)) return null;
  assert(nums.every(isNumber), `expression must evalue to array of numbers.`);
  return compute(nums);
}
export {
  processBitwise
};
