import { computeValue } from "../../../core";
import { assert, compare, isArray } from "../../../util";
const $cmp = (obj, expr, options) => {
  const args = computeValue(obj, expr, null, options);
  assert(
    isArray(args) && args.length == 2,
    "$cmp: expression must resolve to array of size 2."
  );
  return compare(args[0], args[1]);
};
export {
  $cmp
};
