import { computeValue } from "../../../core";
import { assert, isNil, isObject, typeOf } from "../../../util";
const $objectToArray = (obj, expr, options) => {
  const val = computeValue(obj, expr, null, options);
  if (isNil(val)) return null;
  assert(
    isObject(val),
    `$objectToArray requires a document input, found: ${typeOf(val)}`
  );
  const entries = Object.entries(val);
  const result = new Array(entries.length);
  let i = 0;
  for (const [k, v] of entries) {
    result[i++] = { k, v };
  }
  return result;
};
export {
  $objectToArray
};
