import { computeValue } from "../../../core";
import { assert, flatten, isArray, isNil, unique } from "../../../util";
const $setUnion = (obj, expr, options) => {
  const args = computeValue(obj, expr, null, options);
  if (isNil(args)) return null;
  assert(isArray(args), "$setUnion operands must be arrays.");
  if (args.some(isNil)) return null;
  return unique(flatten(args), options?.hashFunction);
};
export {
  $setUnion
};
