import { computeValue } from "../../../core";
import { isString } from "../../../util";
const $substr = (obj, expr, options) => {
  const [s, start, count] = computeValue(obj, expr, null, options);
  if (start < 0 || !isString(s)) return "";
  if (count < 0) return s.substring(start);
  return s.substring(start, start + count);
};
export {
  $substr
};
