import { computeValue } from "../../../core";
import { assert } from "../../../util";
function processOperator(obj, expr, options, fn, fixedPoints) {
  const fp = {
    undefined: null,
    null: null,
    NaN: NaN,
    Infinity: new Error(),
    "-Infinity": new Error(),
    ...fixedPoints
  };
  const n = computeValue(obj, expr, null, options);
  if (n in fp) {
    const res = fp[n];
    const err = res instanceof Error;
    assert(!err, `$${fn.name}: value must be in range (-inf,inf)`);
    return !err && res;
  }
  return fn(n);
}
export {
  processOperator
};
