import { computeValue } from "../../../core";
import { assert, isDate, isNil, isNumber, isString } from "../../../util";
const MAX_INT = 2147483647;
const MIN_INT = -2147483648;
const MAX_LONG = 9007199254740991;
const MIN_LONG = -9007199254740991;
function toInteger(obj, expr, options, min, max) {
  const val = computeValue(obj, expr, null, options);
  if (val === true) return 1;
  if (val === false) return 0;
  if (isNil(val)) return null;
  if (isDate(val)) return val.getTime();
  const n = Number(val);
  assert(
    isNumber(n) && n >= min && n <= max && (!isString(val) || n.toString().indexOf(".") === -1),
    `cannot convert '${val}' to ${max == MAX_INT ? "int" : "long"}`
  );
  return Math.trunc(n);
}
export {
  MAX_INT,
  MAX_LONG,
  MIN_INT,
  MIN_LONG,
  toInteger
};
