import { $documents } from "./documents";
const isUnbounded = (window) => {
  const boundary = window?.documents || window?.range;
  return !boundary || boundary[0] === "unbounded" && boundary[1] === "unbounded";
};
function filterDocumentsStage(pipeline, options) {
  const docs = !!pipeline && pipeline[0]?.$documents;
  if (!docs) return { pipeline };
  return {
    documents: $documents(null, docs, options).value(),
    pipeline: pipeline.slice(1)
  };
}
export {
  filterDocumentsStage,
  isUnbounded
};
