import { Lazy } from "../../lazy";
import { assert, isEmpty, isString } from "../../util";
const $count = (collection, expr, _options) => {
  assert(
    isString(expr) && !isEmpty(expr) && expr.indexOf(".") === -1 && expr.trim()[0] !== "$",
    "Invalid expression value for $count"
  );
  return Lazy([
    {
      [expr]: collection.size()
    }
  ]);
};
export {
  $count
};
