import {
  computeValue,
  ProcessingMode
} from "../../core";
import { Lazy } from "../../lazy";
import { assert, cloneDeep, isArray } from "../../util";
const $documents = (_, expr, options) => {
  const docs = computeValue(null, expr, null, options);
  assert(isArray(docs), "$documents: expression must resolve to an array.");
  const iter = Lazy(docs);
  const mode = options.processingMode;
  return mode & ProcessingMode.CLONE_ALL ? iter.map(cloneDeep) : iter;
};
export {
  $documents
};
