import { Aggregator } from "../../aggregator";
import { concat, Lazy } from "../../lazy";
import { assert, isArray, isString } from "../../util";
import { filterDocumentsStage } from "./_internal";
const $unionWith = (collection, expr, options) => {
  const { coll, pipeline: p } = isString(expr) || isArray(expr) ? { coll: expr } : expr;
  const arr = isString(coll) ? options.collectionResolver(coll) : coll;
  const { documents, pipeline } = filterDocumentsStage(p ?? [], options);
  assert(
    !arr !== !documents,
    "$unionWith: must specify single collection input with `expr.coll` or `expr.pipeline`."
  );
  const xs = arr ?? documents;
  return concat(
    collection,
    pipeline ? new Aggregator(pipeline, options).stream(xs) : Lazy(xs)
  );
};
export {
  $unionWith
};
