import { isArray, resolve, resolveGraph } from "../../../util";
const $exists = (selector, value, _options) => {
  const nested = selector.includes(".");
  const b = !!value;
  if (!nested || selector.match(/\.\d+$/)) {
    return (o) => resolve(o, selector) !== void 0 === b;
  }
  return (o) => {
    const path = resolveGraph(o, selector, { preserveIndex: true });
    const val = resolve(path, selector.substring(0, selector.lastIndexOf(".")));
    return isArray(val) ? val.some((v) => v !== void 0) === b : val !== void 0 === b;
  };
};
export {
  $exists
};
