import { isEqual } from "../../util";
import {
  applyUpdate,
  clone,
  UPDATE_OPTIONS,
  walkExpression
} from "./_internal";
const $set = (obj, expr, arrayFilters = [], options = UPDATE_OPTIONS) => {
  return walkExpression(expr, arrayFilters, options, (val, node, queries) => {
    return applyUpdate(
      obj,
      node,
      queries,
      (o, k) => {
        if (isEqual(o[k], val)) return false;
        o[k] = clone(options.cloneMode, val);
        return true;
      },
      { buildGraph: true }
    );
  });
};
export {
  $set
};
