import { Options } from "../../../core";
import { Any, TimeUnit } from "../../../types";
declare const ISO_WEEKDAYS: readonly ["mon", "mon", "tue", "wed", "thu", "fri", "sat", "sun"];
export type DayOfWeek = "monday" | "tuesday" | "wednesday" | "thursday" | "friday" | "saturday" | "sunday" | (typeof ISO_WEEKDAYS)[number];
export declare const LEAP_YEAR_REF_POINT = -1000000000;
export declare const DAYS_PER_WEEK = 7;
export declare const isLeapYear: (y: number) => boolean;
export declare const dayOfYear: (d: Date) => number;
/** Returns the ISO day of week. Mon=1,Tue=2,...,Sun=7 */
export declare const isoWeekday: (date: Date, startOfWeek: DayOfWeek) => number;
export declare function isoWeek(d: Date): number;
export declare function isoWeekYear(d: Date): number;
export declare const MINUTES_PER_HOUR = 60;
export declare const TIMEUNIT_IN_MILLIS: Readonly<Record<Exclude<TimeUnit, "year" | "quarter" | "month">, number>>;
export declare const DATE_FORMAT = "%Y-%m-%dT%H:%M:%S.%LZ";
export declare const DATE_PART_INTERVAL: readonly [readonly ["year", 0, 9999], readonly ["month", 1, 12], readonly ["day", 1, 31], readonly ["hour", 0, 23], readonly ["minute", 0, 59], readonly ["second", 0, 59], readonly ["millisecond", 0, 999]];
export interface DatePartFormatter {
    name: string;
    padding: number;
    re: RegExp;
}
export declare const MONTHS: readonly ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
/** Table of date format specifiers. Defined statically to support tree-shaking. */
export declare const DATE_SYM_TABLE: Readonly<Record<string, DatePartFormatter>>;
/** Regex for capturing format specifiers in groups. Defined statically to support tree-shaking.  */
export declare const DATE_FORMAT_SYM_RE: RegExp;
/** Regex for splitting date string by format specifiers. Defined statically for tree-shaking.  */
export declare const DATE_FORMAT_SEP_RE: RegExp;
/**
 * Parse and return the timezone string as a number
 * @param tzstr Timezone string matching '+/-hh[:][mm]' or Olson name.
 */
export declare function parseTimezone(tzstr?: string): number;
/**
 * Formats the timezone for output
 * @param tz A timezone object
 */
export declare function formatTimezone(minuteOffset: number): string;
/**
 * Adjust the date by the given timezone
 * @param d Date object
 * @param minuteOffset number
 */
export declare function adjustDate(d: Date, minuteOffset: number): void;
/**
 * Computes a date expression
 * @param obj The target object
 * @param expr Any value that resolves to a valid date expression. Valid expressions include a number, Date, or Object{date: number|Date, timezone?: string}
 */
export declare function computeDate(obj: Any, expr: Any, options: Options): Date;
export declare function padDigits(n: number, digits: number): string;
/**
 * Sums the number of days in the Gregorian calendar in years: 'startYear',
 * 'startYear'+1, .., 'endYear'-1. 'startYear' and 'endYear' are expected to be from the range
 * (-1000'000'000; +1000'000'000).
 *
 * See {@link https://github.com/mongodb/mongo/blob/master/src/mongo/db/query/datetime/date_time_support.cpp#L762}
 */
export declare function daysBetweenYears(startYear: number, endYear: number): number;
export declare const dateDiffYear: (start: Date, end: Date) => number;
export declare const dateDiffMonth: (start: Date, end: Date) => number;
export declare const dateDiffQuarter: (start: Date, end: Date) => number;
export declare const dateDiffDay: (start: Date, end: Date) => number;
export declare const dateDiffWeek: (start: Date, end: Date, startOfWeek?: DayOfWeek) => number;
export declare const dateDiffHour: (start: Date, end: Date) => number;
export declare const dateAdd: (date: Date, unit: TimeUnit, amount: number, _timezone?: string) => Date;
export {};
