import { Options } from "../../../core";
import { Any, AnyObject, Callback } from "../../../types";
/**
 * Processes a trigonometric operator on a value with special handling for fixed points.
 *
 * @param obj - The object containing the value to process
 * @param expr - The expression to evaluate
 * @param options - Options for computation
 * @param fn - Callback function to apply on the computed value
 * @param fixedPoints - Optional map of fixed point values to handle specially (defaults to FIXED_POINTS)
 * @returns The result of applying the trigonometric operation, or null
 * @throws {AssertionError} When trying to apply operation on invalid fixed points
 */
export declare function processOperator(obj: AnyObject, expr: Any, options: Options, fn: Callback<number | null>, fixedPoints?: Record<string, null | number | Error>): number | null;
