import { Options } from "../../core";
import { Any, AnyObject, Callback, TimeUnit, WindowOperatorInput } from "../../types";
export type WindowTimeUnit = Exclude<TimeUnit, "year" | "quarter" | "month">;
/** used for testing only. check that the collection and optional key is cached */
export declare const cached: (xs: AnyObject[]) => boolean;
/**
 * A utility function that manages memoization for window operators.
 * It caches intermediate results for a given collection and field,
 * and ensures proper cleanup after processing.
 *
 * @template T - The type of the cached value.
 * @template R - The return type of the callback function.
 * @param collection - The collection of documents being processed.
 * @param expr - The window operator input containing metadata such as the field name and document number.
 * @param initialize - A callback function that computes and returns the cached value for the field.
 * @param fn - A callback function that processes the cached value and returns the result.
 * @returns The result of the `fn` callback function.
 * @throws Any errors thrown by the `fn` callback function.
 */
export declare function withMemo<T = Any, R = Any>(collection: AnyObject[], expr: Pick<WindowOperatorInput, "field" | "documentNumber">, initialize: Callback<T>, fn: Callback<R, T>): R;
/** Returns the position of a document in the $setWindowFields stage partition. */
export declare function rank(_: AnyObject, collection: AnyObject[], expr: WindowOperatorInput, options: Options, dense: boolean): Any;
