"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Attachments = exports.dynamicUploadMiddleware = void 0;
const errorHandler_1 = require("../middleware/errorHandler");
const responseHandler_1 = require("../../utils/responseHandler");
const upload_1 = require("../../utils/upload");
// interface UpdateOptions extends Request {
//     model: string,
//     type: string,
//     file: any
// }
const dynamicUploadMiddleware = (req, res, next) => {
    const { model, type } = req.headers;
    const types = ['image', 'file'];
    if (!type) {
        return next(new errorHandler_1.AppError(422, "Type is required"));
    }
    if (!model) {
        return next(new errorHandler_1.AppError(422, "Model is required"));
    }
    if (!types.includes(type)) {
        return next(new errorHandler_1.AppError(422, "Type is not supported"));
    }
    let filePath = type === "image" ? "images" : "files";
    const fileUploader = (0, upload_1.upload)(model, filePath).single("file");
    fileUploader(req, res, (uploadErr) => {
        if (uploadErr) {
            if (uploadErr.message.includes("Invalid file type")) {
                return res.status(400).json({ success: false, message: uploadErr.message });
            }
            return next(new errorHandler_1.AppError(500, uploadErr.message || "File upload failed."));
        }
        next();
    });
};
exports.dynamicUploadMiddleware = dynamicUploadMiddleware;
const Attachments = (req, res) => {
    const file = req.file;
    responseHandler_1.ResponseHandler.success(res, file?.filename, 'Uploaded file successfully');
};
exports.Attachments = Attachments;
