"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.settingIndex = void 0;
const responseHandler_1 = require("../../../utils/responseHandler");
const settings_1 = __importDefault(require("../../models/settings"));
const settingIndex = async (req, res) => {
    try {
        // Fetch all settings and convert to key-value object
        const allSettings = await settings_1.default.findAll();
        const settingsResponse = allSettings.reduce((acc, setting) => {
            acc[setting.key] = setting.value;
            return acc;
        }, {});
        // Get requested language
        const lang = req.headers["accept-language"] ||
            req.headers["Accept-Language"] ||
            "en";
        const response = {
            ...settingsResponse,
        };
        // Send success response
        responseHandler_1.ResponseHandler.success(res, response);
    }
    catch (error) {
        const errorMessage = error instanceof Error ? error.message : "Failed to fetch settings";
        responseHandler_1.ResponseHandler.error(res, errorMessage, 500);
    }
};
exports.settingIndex = settingIndex;
