"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.authenticateToken = void 0;
const jsonwebtoken_1 = __importDefault(require("jsonwebtoken"));
const index_1 = __importDefault(require("../config/index"));
const authenticateToken = (req, res, next) => {
    const authHeader = req.headers["authorization"];
    if (authHeader) {
        const token = authHeader.split(" ")[1];
        jsonwebtoken_1.default.verify(token, index_1.default.SECRET_KEY, (err, user) => {
            if (err) {
                res.status(401).json({ message: "Unauthorized access" });
                return;
            }
            req.user = user;
            next();
        });
    }
    else {
        res.status(401).json({ message: "No token provided" });
    }
};
exports.authenticateToken = authenticateToken;
