"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateRequest = void 0;
const joi_1 = __importDefault(require("joi"));
const validateRequest = (schema) => {
    return async (req, res, next) => {
        try {
            await schema.validateAsync({
                body: req.body,
                query: req.query,
                params: req.params,
            }, { abortEarly: false });
            next();
        }
        catch (error) {
            if (error instanceof joi_1.default.ValidationError) {
                const errors = error.details.map((detail) => ({
                    field: detail.path.join('.'),
                    message: detail.message,
                }));
                res.status(422).json({
                    message: 'Validation failed',
                    errors,
                });
                return;
            }
            next(error);
        }
    };
};
exports.validateRequest = validateRequest;
