"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const sequelize_1 = require("sequelize");
const database_1 = __importDefault(require("../../utils/database"));
class Contacts extends sequelize_1.Model {
}
Contacts.init({
    id: {
        type: sequelize_1.DataTypes.INTEGER,
        primaryKey: true,
        autoIncrement: true,
    },
    email: sequelize_1.DataTypes.STRING,
    name: sequelize_1.DataTypes.STRING,
    phone: sequelize_1.DataTypes.STRING,
    type: sequelize_1.DataTypes.STRING,
    country: sequelize_1.DataTypes.STRING,
    city: sequelize_1.DataTypes.STRING,
    postal_code: sequelize_1.DataTypes.INTEGER,
}, {
    sequelize: database_1.default,
    modelName: "contact",
    underscored: true,
});
exports.default = Contacts;
