"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const sequelize_1 = require("sequelize");
const database_1 = __importDefault(require("../../utils/database"));
const bcrypt_1 = __importDefault(require("bcrypt"));
class User extends sequelize_1.Model {
}
User.init({
    id: {
        type: sequelize_1.DataTypes.INTEGER,
        primaryKey: true,
        autoIncrement: true
    },
    name: sequelize_1.DataTypes.STRING,
    password: sequelize_1.DataTypes.STRING,
    email: sequelize_1.DataTypes.STRING,
    role: {
        type: sequelize_1.DataTypes.STRING,
        allowNull: true
    },
    phone: sequelize_1.DataTypes.STRING,
    isActive: {
        type: sequelize_1.DataTypes.BOOLEAN,
        allowNull: false,
        defaultValue: true,
    },
    image: {
        type: sequelize_1.DataTypes.STRING,
        allowNull: true,
    }
}, {
    sequelize: database_1.default,
    modelName: 'User',
    timestamps: true,
    underscored: true,
    paranoid: true, // Soft deletes
    defaultScope: {
        attributes: { exclude: ['password'] }
    },
    scopes: {
        withPassword: { attributes: { include: ["password"] } }, // ✅ Allows including password when needed
    },
});
// const adminUsers = await User.scope("admin").findAll(); get all users where role = 'admin'
User.addHook('beforeCreate', async (user) => {
    if (user.password) {
        user.password = await bcrypt_1.default.hash(user.password, 10);
    }
});
exports.default = User;
