"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ResponseHandler = void 0;
class ResponseHandler {
    static success(res, data, message = 'Success') {
        return res.status(200).json({
            status: 'success',
            message,
            data,
        });
    }
    static paginated(res, data, message = 'Success') {
        return res.status(200).json({
            status: 'success',
            message,
            ...data,
        });
    }
    static created(res, data, message = 'Created successfully') {
        return res.status(201).json({
            status: 'success',
            message,
            data,
        });
    }
    static deleted(res, data, message = 'Deleted successfully') {
        return res.status(201).json({
            status: 'success',
            message,
            data,
        });
    }
    static failed(res, errors, message = '') {
        const allErrors = errors.map(err => err + ' is required');
        return res.status(422).json({
            status: 'fail',
            message: message ? message : allErrors.length ? allErrors[0] : '',
            errors: allErrors
        });
    }
    static error(res, message = 'Internal server error', statusCode = 500, errors) {
        return res.status(statusCode).json({
            status: 'fail',
            message,
            errors,
        });
    }
}
exports.ResponseHandler = ResponseHandler;
