import { defineComponent, ref, mergeProps, unref, reactive, withCtx, createVNode, withModifiers, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrRenderComponent, ssrRenderStyle, ssrIncludeBooleanAttr } from 'vue/server-renderer';
import { _ as _export_sfc } from './server.mjs';
import { u as useToast, F as Form, a as Field, E as ErrorMessage } from './useToast-DixuLKfl.mjs';
import * as yup from 'yup';
import axios from 'axios';
import { u as useHead } from './v3-D__bBwor.mjs';
import '../_/nitro.mjs';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'node:fs';
import 'node:url';
import 'ipx';
import 'node:path';
import 'node:crypto';
import 'vue-router';
import '../routes/renderer.mjs';
import 'vue-bundle-renderer/runtime';
import 'unhead/server';
import 'devalue';
import 'unhead/utils';
import 'unhead/plugins';

const _sfc_main$4 = {};
function _sfc_ssrRender$1(_ctx, _push, _parent, _attrs) {
  _push(`<section${ssrRenderAttrs(mergeProps({ class: "hero-banner" }, _attrs))}><div class="banner-slide"><div class="banner-image"><div><img alt="" src="https://www.elito.com/wp-content/uploads/2024/04/contact_bg.jpg"></div><div class="banner-caption"><h1><small>\u062A\u0648\u0627\u0635\u0644 \u0645\u0639\u0646\u0627 \u0644\u0640</small><span style="${ssrRenderStyle({ "color": "#ee2a24" })}">\u062A\u062C\u0631\u0628\u0629 \u0627\u0644\u0641\u0631\u0642</span></h1><p> \u062A\u062C\u0631\u0628\u0629 \u0639\u0645\u0644\u0627\u0621 \u0639\u0627\u0644\u0645\u064A\u0629 \u0627\u0644\u0645\u0633\u062A\u0648\u0649 \u0648\u062D\u0644\u0648\u0644 \u0633\u0631\u064A\u0639\u0629 \u0644\u0627\u0633\u062A\u0641\u0633\u0627\u0631\u0627\u062A\u0643<br> \u0641\u064A \u062E\u062F\u0645\u062A\u0643 \u062F\u0627\u0626\u0645\u064B\u0627 </p></div></div></div></section>`);
}
const _sfc_setup$4 = _sfc_main$4.setup;
_sfc_main$4.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/contact/Hero.vue");
  return _sfc_setup$4 ? _sfc_setup$4(props, ctx) : void 0;
};
const __nuxt_component_0 = /* @__PURE__ */ _export_sfc(_sfc_main$4, [["ssrRender", _sfc_ssrRender$1]]);
const _sfc_main$3 = {};
function _sfc_ssrRender(_ctx, _push, _parent, _attrs) {
  _push(`<section${ssrRenderAttrs(mergeProps({ class: "section" }, _attrs))}><div class="container"><div class="search-block"><div class="brach-block"><h3 class="title">BRANCH OFFICE</h3><div class="contact-info"><div class="branch-office-address"><div><h3>Amara Raja Energy &amp; Mobility Limited</h3><p> 405/406 Raindrops Building, Opp. Ford Cargo Motors,<br> Nr. Union Bank, C.G.Road, Ahmedabad \u2013 380006 </p></div><div class="contact-via"><p><span class="icon"><svg fill="currentColor" version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 473.806 473.806" xml:space="preserve"><path d="M374.456,293.506c-9.7-10.1-21.4-15.5-33.8-15.5c-12.3,0-24.1,5.3-34.2,15.4l-31.6,31.5c-2.6-1.4-5.2-2.7-7.7-4
		c-3.6-1.8-7-3.5-9.9-5.3c-29.6-18.8-56.5-43.3-82.3-75c-12.5-15.8-20.9-29.1-27-42.6c8.2-7.5,15.8-15.3,23.2-22.8
		c2.8-2.8,5.6-5.7,8.4-8.5c21-21,21-48.2,0-69.2l-27.3-27.3c-3.1-3.1-6.3-6.3-9.3-9.5c-6-6.2-12.3-12.6-18.8-18.6
		c-9.7-9.6-21.3-14.7-33.5-14.7s-24,5.1-34,14.7c-0.1,0.1-0.1,0.1-0.2,0.2l-34,34.3c-12.8,12.8-20.1,28.4-21.7,46.5
		c-2.4,29.2,6.2,56.4,12.8,74.2c16.2,43.7,40.4,84.2,76.5,127.6c43.8,52.3,96.5,93.6,156.7,122.7c23,10.9,53.7,23.8,88,26
		c2.1,0.1,4.3,0.2,6.3,0.2c23.1,0,42.5-8.3,57.7-24.8c0.1-0.2,0.3-0.3,0.4-0.5c5.2-6.3,11.2-12,17.5-18.1c4.3-4.1,8.7-8.4,13-12.9
		c9.9-10.3,15.1-22.3,15.1-34.6c0-12.4-5.3-24.3-15.4-34.3L374.456,293.506z M410.256,398.806
		C410.156,398.806,410.156,398.906,410.256,398.806c-3.9,4.2-7.9,8-12.2,12.2c-6.5,6.2-13.1,12.7-19.3,20
		c-10.1,10.8-22,15.9-37.6,15.9c-1.5,0-3.1,0-4.6-0.1c-29.7-1.9-57.3-13.5-78-23.4c-56.6-27.4-106.3-66.3-147.6-115.6
		c-34.1-41.1-56.9-79.1-72-119.9c-9.3-24.9-12.7-44.3-11.2-62.6c1-11.7,5.5-21.4,13.8-29.7l34.1-34.1c4.9-4.6,10.1-7.1,15.2-7.1
		c6.3,0,11.4,3.8,14.6,7c0.1,0.1,0.2,0.2,0.3,0.3c6.1,5.7,11.9,11.6,18,17.9c3.1,3.2,6.3,6.4,9.5,9.7l27.3,27.3
		c10.6,10.6,10.6,20.4,0,31c-2.9,2.9-5.7,5.8-8.6,8.6c-8.4,8.6-16.4,16.6-25.1,24.4c-0.2,0.2-0.4,0.3-0.5,0.5
		c-8.6,8.6-7,17-5.2,22.7c0.1,0.3,0.2,0.6,0.3,0.9c7.1,17.2,17.1,33.4,32.3,52.7l0.1,0.1c27.6,34,56.7,60.5,88.8,80.8
		c4.1,2.6,8.3,4.7,12.3,6.7c3.6,1.8,7,3.5,9.9,5.3c0.4,0.2,0.8,0.5,1.2,0.7c3.4,1.7,6.6,2.5,9.9,2.5c8.3,0,13.5-5.2,15.2-6.9
		l34.2-34.2c3.4-3.4,8.8-7.5,15.1-7.5c6.2,0,11.3,3.9,14.4,7.3c0.1,0.1,0.1,0.1,0.2,0.2l55.1,55.1
		C420.456,377.706,420.456,388.206,410.256,398.806z"></path><path d="M256.056,112.706c26.2,4.4,50,16.8,69,35.8s31.3,42.8,35.8,69c1.1,6.6,6.8,11.2,13.3,11.2c0.8,0,1.5-0.1,2.3-0.2
		c7.4-1.2,12.3-8.2,11.1-15.6c-5.4-31.7-20.4-60.6-43.3-83.5s-51.8-37.9-83.5-43.3c-7.4-1.2-14.3,3.7-15.6,11
		S248.656,111.506,256.056,112.706z"></path><path d="M473.256,209.006c-8.9-52.2-33.5-99.7-71.3-137.5s-85.3-62.4-137.5-71.3c-7.3-1.3-14.2,3.7-15.5,11
		c-1.2,7.4,3.7,14.3,11.1,15.6c46.6,7.9,89.1,30,122.9,63.7c33.8,33.8,55.8,76.3,63.7,122.9c1.1,6.6,6.8,11.2,13.3,11.2
		c0.8,0,1.5-0.1,2.3-0.2C469.556,223.306,474.556,216.306,473.256,209.006z"></path></svg></span> +91 79 4900 4747 </p></div></div></div></div><div class="corporate-block"><h3 class="title">Corporate Office</h3><div class="contact-info"><h3>Amara Raja Energy &amp; Mobility Limited</h3><p> TERMINAL A<br> 1-18/1/AMR/NR, Nanakramguda Gachilbowli,<br> Hyderabad \u2013 500032<br> India </p><div class="contact-via"><p><span class="icon"><svg fill="currentColor" version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 473.806 473.806" xml:space="preserve"><path d="M374.456,293.506c-9.7-10.1-21.4-15.5-33.8-15.5c-12.3,0-24.1,5.3-34.2,15.4l-31.6,31.5c-2.6-1.4-5.2-2.7-7.7-4
			c-3.6-1.8-7-3.5-9.9-5.3c-29.6-18.8-56.5-43.3-82.3-75c-12.5-15.8-20.9-29.1-27-42.6c8.2-7.5,15.8-15.3,23.2-22.8
			c2.8-2.8,5.6-5.7,8.4-8.5c21-21,21-48.2,0-69.2l-27.3-27.3c-3.1-3.1-6.3-6.3-9.3-9.5c-6-6.2-12.3-12.6-18.8-18.6
			c-9.7-9.6-21.3-14.7-33.5-14.7s-24,5.1-34,14.7c-0.1,0.1-0.1,0.1-0.2,0.2l-34,34.3c-12.8,12.8-20.1,28.4-21.7,46.5
			c-2.4,29.2,6.2,56.4,12.8,74.2c16.2,43.7,40.4,84.2,76.5,127.6c43.8,52.3,96.5,93.6,156.7,122.7c23,10.9,53.7,23.8,88,26
			c2.1,0.1,4.3,0.2,6.3,0.2c23.1,0,42.5-8.3,57.7-24.8c0.1-0.2,0.3-0.3,0.4-0.5c5.2-6.3,11.2-12,17.5-18.1c4.3-4.1,8.7-8.4,13-12.9
			c9.9-10.3,15.1-22.3,15.1-34.6c0-12.4-5.3-24.3-15.4-34.3L374.456,293.506z M410.256,398.806
			C410.156,398.806,410.156,398.906,410.256,398.806c-3.9,4.2-7.9,8-12.2,12.2c-6.5,6.2-13.1,12.7-19.3,20
			c-10.1,10.8-22,15.9-37.6,15.9c-1.5,0-3.1,0-4.6-0.1c-29.7-1.9-57.3-13.5-78-23.4c-56.6-27.4-106.3-66.3-147.6-115.6
			c-34.1-41.1-56.9-79.1-72-119.9c-9.3-24.9-12.7-44.3-11.2-62.6c1-11.7,5.5-21.4,13.8-29.7l34.1-34.1c4.9-4.6,10.1-7.1,15.2-7.1
			c6.3,0,11.4,3.8,14.6,7c0.1,0.1,0.2,0.2,0.3,0.3c6.1,5.7,11.9,11.6,18,17.9c3.1,3.2,6.3,6.4,9.5,9.7l27.3,27.3
			c10.6,10.6,10.6,20.4,0,31c-2.9,2.9-5.7,5.8-8.6,8.6c-8.4,8.6-16.4,16.6-25.1,24.4c-0.2,0.2-0.4,0.3-0.5,0.5
			c-8.6,8.6-7,17-5.2,22.7c0.1,0.3,0.2,0.6,0.3,0.9c7.1,17.2,17.1,33.4,32.3,52.7l0.1,0.1c27.6,34,56.7,60.5,88.8,80.8
			c4.1,2.6,8.3,4.7,12.3,6.7c3.6,1.8,7,3.5,9.9,5.3c0.4,0.2,0.8,0.5,1.2,0.7c3.4,1.7,6.6,2.5,9.9,2.5c8.3,0,13.5-5.2,15.2-6.9
			l34.2-34.2c3.4-3.4,8.8-7.5,15.1-7.5c6.2,0,11.3,3.9,14.4,7.3c0.1,0.1,0.1,0.1,0.2,0.2l55.1,55.1
			C420.456,377.706,420.456,388.206,410.256,398.806z"></path><path d="M256.056,112.706c26.2,4.4,50,16.8,69,35.8s31.3,42.8,35.8,69c1.1,6.6,6.8,11.2,13.3,11.2c0.8,0,1.5-0.1,2.3-0.2
			c7.4-1.2,12.3-8.2,11.1-15.6c-5.4-31.7-20.4-60.6-43.3-83.5s-51.8-37.9-83.5-43.3c-7.4-1.2-14.3,3.7-15.6,11
			S248.656,111.506,256.056,112.706z"></path><path d="M473.256,209.006c-8.9-52.2-33.5-99.7-71.3-137.5s-85.3-62.4-137.5-71.3c-7.3-1.3-14.2,3.7-15.5,11
			c-1.2,7.4,3.7,14.3,11.1,15.6c46.6,7.9,89.1,30,122.9,63.7c33.8,33.8,55.8,76.3,63.7,122.9c1.1,6.6,6.8,11.2,13.3,11.2
			c0.8,0,1.5-0.1,2.3-0.2C469.556,223.306,474.556,216.306,473.256,209.006z"></path></svg></span> 1800 425 3838<small>(Toll Free Number, India)</small></p><p><span class="icon"><svg fill="currentColor" version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 483.3 483.3" xml:space="preserve"><path d="M424.3,57.75H59.1c-32.6,0-59.1,26.5-59.1,59.1v249.6c0,32.6,26.5,59.1,59.1,59.1h365.1c32.6,0,59.1-26.5,59.1-59.1
			v-249.5C483.4,84.35,456.9,57.75,424.3,57.75z M456.4,366.45c0,17.7-14.4,32.1-32.1,32.1H59.1c-17.7,0-32.1-14.4-32.1-32.1v-249.5
			c0-17.7,14.4-32.1,32.1-32.1h365.1c17.7,0,32.1,14.4,32.1,32.1v249.5H456.4z"></path><path d="M304.8,238.55l118.2-106c5.5-5,6-13.5,1-19.1c-5-5.5-13.5-6-19.1-1l-163,146.3l-31.8-28.4c-0.1-0.1-0.2-0.2-0.2-0.3
			c-0.7-0.7-1.4-1.3-2.2-1.9L78.3,112.35c-5.6-5-14.1-4.5-19.1,1.1c-5,5.6-4.5,14.1,1.1,19.1l119.6,106.9L60.8,350.95
			c-5.4,5.1-5.7,13.6-0.6,19.1c2.7,2.8,6.3,4.3,9.9,4.3c3.3,0,6.6-1.2,9.2-3.6l120.9-113.1l32.8,29.3c2.6,2.3,5.8,3.4,9,3.4
			c3.2,0,6.5-1.2,9-3.5l33.7-30.2l120.2,114.2c2.6,2.5,6,3.7,9.3,3.7c3.6,0,7.1-1.4,9.8-4.2c5.1-5.4,4.9-14-0.5-19.1L304.8,238.55z"></path></svg></span><a href="javascript:void(0);">mktgabd@amararaja.com</a></p></div></div></div></div></div></section>`);
}
const _sfc_setup$3 = _sfc_main$3.setup;
_sfc_main$3.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/contact/Branch.vue");
  return _sfc_setup$3 ? _sfc_setup$3(props, ctx) : void 0;
};
const __nuxt_component_1 = /* @__PURE__ */ _export_sfc(_sfc_main$3, [["ssrRender", _sfc_ssrRender]]);
const _sfc_main$2 = {
  __name: "Form1",
  __ssrInlineRender: true,
  setup(__props) {
    const toast = useToast();
    const btnloading = ref(false);
    const initialValues = reactive({
      type: "\u0634\u0631\u0627\u0621 \u0645\u0646\u062A\u062C \u062C\u062F\u064A\u062F",
      name: "",
      country: "",
      city: "",
      postal_code: "",
      email: "",
      phone: ""
    });
    const schema = yup.object().shape({
      name: yup.string().required("\u0627\u0644\u0627\u0633\u0645 \u0645\u0637\u0644\u0648\u0628"),
      country: yup.string().required("\u0627\u0644\u062F\u0648\u0644\u0629 \u0645\u0637\u0644\u0648\u0628\u0629"),
      city: yup.string().required("\u0627\u0644\u0645\u062F\u064A\u0646\u0629 \u0645\u0637\u0644\u0648\u0628\u0629"),
      postal_code: yup.string().required("\u0627\u0644\u0631\u0645\u0632 \u0627\u0644\u0628\u0631\u064A\u062F\u064A \u0645\u0637\u0644\u0648\u0628"),
      email: yup.string().email("\u064A\u062C\u0628 \u0627\u0646 \u064A\u0643\u0648\u0646 \u0628\u0631\u064A\u062F\u0627 \u0635\u062D\u064A\u062D\u0627").required("\u0627\u0644\u0627\u064A\u0645\u064A\u0644 \u0645\u0637\u0644\u0648\u0628"),
      phone: yup.string().required("\u0631\u0642\u0645 \u0627\u0644\u062C\u0648\u0627\u0644 \u0645\u0637\u0644\u0648\u0628")
    });
    function onWheel(event) {
      event.target.blur();
    }
    function onKeyDown(event) {
      if (event.key === "ArrowUp" || event.key === "ArrowDown") {
        event.preventDefault();
      }
    }
    const submit = (values, actions) => {
      btnloading.value = true;
      axios.post("https://elito-admin.najidalqimam.sa/api/web/contacts", values).then((res) => {
        toast.success({
          title: "",
          message: "\u062A\u0645 \u0627\u0631\u0633\u0627\u0644 \u0637\u0644\u0628\u0643 \u0628\u0646\u062C\u0627\u062D"
        });
        actions.resetForm();
      }).catch(() => {
        toast.error({
          title: "\u062D\u062F\u062B \u062E\u0637\u0623",
          message: "\u0644\u0645 \u064A\u062A\u0645 \u0627\u0631\u0633\u0627\u0644 \u0627\u0644\u0637\u0644\u0628 \u0628\u0631\u062C\u0627\u0621 \u062D\u0627\u0648\u0644 \u0645\u0631\u0647 \u0627\u062E\u0631\u064A"
        });
      }).finally(() => {
        btnloading.value = false;
      });
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_VeeForm = Form;
      const _component_VeeField = Field;
      const _component_VeeErrorMessage = ErrorMessage;
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "tab-content" }, _attrs))}><div>`);
      _push(ssrRenderComponent(_component_VeeForm, {
        "initial-values": unref(initialValues),
        onSubmit: submit,
        "aria-label": "Contact form",
        "validation-schema": unref(schema)
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="form-wrapper" id="sales_form"${_scopeId}><div class="form-fields"${_scopeId}><div class="form-field"${_scopeId}><label class="input-label"${_scopeId}>`);
            _push2(ssrRenderComponent(_component_VeeField, {
              class: "wpcf7-form-control sales-query-type",
              name: "type",
              as: "select"
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`<option value="\u0634\u0631\u0627\u0621 \u0645\u0646\u062A\u062C \u062C\u062F\u064A\u062F"${_scopeId2}>\u0634\u0631\u0627\u0621 \u0645\u0646\u062A\u062C \u062C\u062F\u064A\u062F</option><option value="\u0627\u0633\u062A\u0639\u0644\u0627\u0645 \u0639\u0646 \u0623\u0633\u0639\u0627\u0631 \u0627\u0644\u0645\u0646\u062A\u062C\u0627\u062A"${_scopeId2}> \u0627\u0633\u062A\u0639\u0644\u0627\u0645 \u0639\u0646 \u0623\u0633\u0639\u0627\u0631 \u0627\u0644\u0645\u0646\u062A\u062C\u0627\u062A </option><option value="\u0645\u062D\u0637\u0629 \u062A\u0648\u0642\u0641 \u0623\u0645\u0627\u0631\u0648\u0646"${_scopeId2}>\u0645\u062D\u0637\u0629 \u062A\u0648\u0642\u0641 \u0623\u0645\u0627\u0631\u0648\u0646</option><option value="\u0627\u0633\u062A\u0641\u0633\u0627\u0631 \u062A\u062C\u0627\u0631\u064A \u0643\u0628\u064A\u0631 / \u0637\u0644\u0628 \u0628\u0627\u0644\u062C\u0645\u0644\u0629"${_scopeId2}> \u0627\u0633\u062A\u0641\u0633\u0627\u0631 \u062A\u062C\u0627\u0631\u064A \u0643\u0628\u064A\u0631 / \u0637\u0644\u0628 \u0628\u0627\u0644\u062C\u0645\u0644\u0629 </option>`);
                } else {
                  return [
                    createVNode("option", { value: "\u0634\u0631\u0627\u0621 \u0645\u0646\u062A\u062C \u062C\u062F\u064A\u062F" }, "\u0634\u0631\u0627\u0621 \u0645\u0646\u062A\u062C \u062C\u062F\u064A\u062F"),
                    createVNode("option", { value: "\u0627\u0633\u062A\u0639\u0644\u0627\u0645 \u0639\u0646 \u0623\u0633\u0639\u0627\u0631 \u0627\u0644\u0645\u0646\u062A\u062C\u0627\u062A" }, " \u0627\u0633\u062A\u0639\u0644\u0627\u0645 \u0639\u0646 \u0623\u0633\u0639\u0627\u0631 \u0627\u0644\u0645\u0646\u062A\u062C\u0627\u062A "),
                    createVNode("option", { value: "\u0645\u062D\u0637\u0629 \u062A\u0648\u0642\u0641 \u0623\u0645\u0627\u0631\u0648\u0646" }, "\u0645\u062D\u0637\u0629 \u062A\u0648\u0642\u0641 \u0623\u0645\u0627\u0631\u0648\u0646"),
                    createVNode("option", { value: "\u0627\u0633\u062A\u0641\u0633\u0627\u0631 \u062A\u062C\u0627\u0631\u064A \u0643\u0628\u064A\u0631 / \u0637\u0644\u0628 \u0628\u0627\u0644\u062C\u0645\u0644\u0629" }, " \u0627\u0633\u062A\u0641\u0633\u0627\u0631 \u062A\u062C\u0627\u0631\u064A \u0643\u0628\u064A\u0631 / \u0637\u0644\u0628 \u0628\u0627\u0644\u062C\u0645\u0644\u0629 ")
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(ssrRenderComponent(_component_VeeErrorMessage, { name: "type" }, null, _parent2, _scopeId));
            _push2(`</label></div><div class="form-field"${_scopeId}><label class="input-label"${_scopeId}>`);
            _push2(ssrRenderComponent(_component_VeeField, {
              type: "text",
              size: "40",
              maxlength: "400",
              class: "wpcf7-form-control wpcf7-text wpcf7-validates-as-required",
              name: "name",
              placeholder: "\u0627\u0644\u0627\u0633\u0645"
            }, null, _parent2, _scopeId));
            _push2(ssrRenderComponent(_component_VeeErrorMessage, {
              class: "text-red-500",
              name: "name"
            }, null, _parent2, _scopeId));
            _push2(`</label></div><div class="form-field"${_scopeId}><label class="input-label"${_scopeId}>`);
            _push2(ssrRenderComponent(_component_VeeField, {
              type: "text",
              size: "40",
              maxlength: "400",
              class: "wpcf7-form-control wpcf7-text wpcf7-validates-as-required",
              name: "country",
              placeholder: "\u0627\u0644\u062F\u0648\u0644\u0629"
            }, null, _parent2, _scopeId));
            _push2(ssrRenderComponent(_component_VeeErrorMessage, {
              class: "text-red-500",
              name: "country"
            }, null, _parent2, _scopeId));
            _push2(`</label></div><div class="form-field"${_scopeId}><label class="input-label"${_scopeId}>`);
            _push2(ssrRenderComponent(_component_VeeField, {
              type: "text",
              size: "40",
              maxlength: "400",
              class: "wpcf7-form-control wpcf7-text wpcf7-validates-as-required",
              name: "city",
              placeholder: "\u0627\u0644\u0645\u062F\u064A\u0646\u0629"
            }, null, _parent2, _scopeId));
            _push2(ssrRenderComponent(_component_VeeErrorMessage, {
              class: "text-red-500",
              name: "city"
            }, null, _parent2, _scopeId));
            _push2(`</label></div><div class="form-field"${_scopeId}><label class="input-label"${_scopeId}>`);
            _push2(ssrRenderComponent(_component_VeeField, {
              type: "number",
              size: "40",
              maxlength: "400",
              class: "wpcf7-form-control wpcf7-text wpcf7-validates-as-required",
              name: "postal_code",
              placeholder: "\u0627\u0644\u0631\u0645\u0632 \u0627\u0644\u0628\u0631\u064A\u062F\u064A",
              onWheel,
              onKeydown: onKeyDown
            }, null, _parent2, _scopeId));
            _push2(ssrRenderComponent(_component_VeeErrorMessage, {
              class: "text-red-500",
              name: "postal_code"
            }, null, _parent2, _scopeId));
            _push2(`</label></div><div class="form-field"${_scopeId}><label class="input-label"${_scopeId}>`);
            _push2(ssrRenderComponent(_component_VeeField, {
              type: "number",
              size: "40",
              maxlength: "400",
              class: "wpcf7-form-control wpcf7-text wpcf7-validates-as-required",
              name: "phone",
              placeholder: "\u0631\u0642\u0645 \u0627\u0644\u062C\u0648\u0627\u0644",
              onWheel,
              onKeydown: onKeyDown
            }, null, _parent2, _scopeId));
            _push2(ssrRenderComponent(_component_VeeErrorMessage, {
              class: "text-red-500",
              name: "phone"
            }, null, _parent2, _scopeId));
            _push2(`</label></div><div class="form-field"${_scopeId}><label class="input-label"${_scopeId}>`);
            _push2(ssrRenderComponent(_component_VeeField, {
              type: "text",
              size: "40",
              maxlength: "400",
              class: "wpcf7-form-control wpcf7-text wpcf7-validates-as-required",
              name: "email",
              placeholder: "\u0627\u0644\u0628\u0631\u064A\u062F \u0627\u0644\u0627\u0644\u0643\u062A\u0631\u0648\u0646\u064A"
            }, null, _parent2, _scopeId));
            _push2(ssrRenderComponent(_component_VeeErrorMessage, {
              class: "text-red-500",
              name: "email"
            }, null, _parent2, _scopeId));
            _push2(`</label></div></div><div class="form-btn"${_scopeId}><button${ssrIncludeBooleanAttr(unref(btnloading)) ? " disabled" : ""} class="has-spinner" type="submit"${_scopeId}> \u0627\u0631\u0633\u0627\u0644 </button></div></div>`);
          } else {
            return [
              createVNode("div", {
                class: "form-wrapper",
                id: "sales_form"
              }, [
                createVNode("div", { class: "form-fields" }, [
                  createVNode("div", { class: "form-field" }, [
                    createVNode("label", { class: "input-label" }, [
                      createVNode(_component_VeeField, {
                        class: "wpcf7-form-control sales-query-type",
                        name: "type",
                        as: "select"
                      }, {
                        default: withCtx(() => [
                          createVNode("option", { value: "\u0634\u0631\u0627\u0621 \u0645\u0646\u062A\u062C \u062C\u062F\u064A\u062F" }, "\u0634\u0631\u0627\u0621 \u0645\u0646\u062A\u062C \u062C\u062F\u064A\u062F"),
                          createVNode("option", { value: "\u0627\u0633\u062A\u0639\u0644\u0627\u0645 \u0639\u0646 \u0623\u0633\u0639\u0627\u0631 \u0627\u0644\u0645\u0646\u062A\u062C\u0627\u062A" }, " \u0627\u0633\u062A\u0639\u0644\u0627\u0645 \u0639\u0646 \u0623\u0633\u0639\u0627\u0631 \u0627\u0644\u0645\u0646\u062A\u062C\u0627\u062A "),
                          createVNode("option", { value: "\u0645\u062D\u0637\u0629 \u062A\u0648\u0642\u0641 \u0623\u0645\u0627\u0631\u0648\u0646" }, "\u0645\u062D\u0637\u0629 \u062A\u0648\u0642\u0641 \u0623\u0645\u0627\u0631\u0648\u0646"),
                          createVNode("option", { value: "\u0627\u0633\u062A\u0641\u0633\u0627\u0631 \u062A\u062C\u0627\u0631\u064A \u0643\u0628\u064A\u0631 / \u0637\u0644\u0628 \u0628\u0627\u0644\u062C\u0645\u0644\u0629" }, " \u0627\u0633\u062A\u0641\u0633\u0627\u0631 \u062A\u062C\u0627\u0631\u064A \u0643\u0628\u064A\u0631 / \u0637\u0644\u0628 \u0628\u0627\u0644\u062C\u0645\u0644\u0629 ")
                        ]),
                        _: 1
                      }),
                      createVNode(_component_VeeErrorMessage, { name: "type" })
                    ])
                  ]),
                  createVNode("div", { class: "form-field" }, [
                    createVNode("label", { class: "input-label" }, [
                      createVNode(_component_VeeField, {
                        type: "text",
                        size: "40",
                        maxlength: "400",
                        class: "wpcf7-form-control wpcf7-text wpcf7-validates-as-required",
                        name: "name",
                        placeholder: "\u0627\u0644\u0627\u0633\u0645"
                      }),
                      createVNode(_component_VeeErrorMessage, {
                        class: "text-red-500",
                        name: "name"
                      })
                    ])
                  ]),
                  createVNode("div", { class: "form-field" }, [
                    createVNode("label", { class: "input-label" }, [
                      createVNode(_component_VeeField, {
                        type: "text",
                        size: "40",
                        maxlength: "400",
                        class: "wpcf7-form-control wpcf7-text wpcf7-validates-as-required",
                        name: "country",
                        placeholder: "\u0627\u0644\u062F\u0648\u0644\u0629"
                      }),
                      createVNode(_component_VeeErrorMessage, {
                        class: "text-red-500",
                        name: "country"
                      })
                    ])
                  ]),
                  createVNode("div", { class: "form-field" }, [
                    createVNode("label", { class: "input-label" }, [
                      createVNode(_component_VeeField, {
                        type: "text",
                        size: "40",
                        maxlength: "400",
                        class: "wpcf7-form-control wpcf7-text wpcf7-validates-as-required",
                        name: "city",
                        placeholder: "\u0627\u0644\u0645\u062F\u064A\u0646\u0629"
                      }),
                      createVNode(_component_VeeErrorMessage, {
                        class: "text-red-500",
                        name: "city"
                      })
                    ])
                  ]),
                  createVNode("div", { class: "form-field" }, [
                    createVNode("label", { class: "input-label" }, [
                      createVNode(_component_VeeField, {
                        type: "number",
                        size: "40",
                        maxlength: "400",
                        class: "wpcf7-form-control wpcf7-text wpcf7-validates-as-required",
                        name: "postal_code",
                        placeholder: "\u0627\u0644\u0631\u0645\u0632 \u0627\u0644\u0628\u0631\u064A\u062F\u064A",
                        onWheel: withModifiers(onWheel, ["prevent"]),
                        onKeydown: onKeyDown
                      }),
                      createVNode(_component_VeeErrorMessage, {
                        class: "text-red-500",
                        name: "postal_code"
                      })
                    ])
                  ]),
                  createVNode("div", { class: "form-field" }, [
                    createVNode("label", { class: "input-label" }, [
                      createVNode(_component_VeeField, {
                        type: "number",
                        size: "40",
                        maxlength: "400",
                        class: "wpcf7-form-control wpcf7-text wpcf7-validates-as-required",
                        name: "phone",
                        placeholder: "\u0631\u0642\u0645 \u0627\u0644\u062C\u0648\u0627\u0644",
                        onWheel: withModifiers(onWheel, ["prevent"]),
                        onKeydown: onKeyDown
                      }),
                      createVNode(_component_VeeErrorMessage, {
                        class: "text-red-500",
                        name: "phone"
                      })
                    ])
                  ]),
                  createVNode("div", { class: "form-field" }, [
                    createVNode("label", { class: "input-label" }, [
                      createVNode(_component_VeeField, {
                        type: "text",
                        size: "40",
                        maxlength: "400",
                        class: "wpcf7-form-control wpcf7-text wpcf7-validates-as-required",
                        name: "email",
                        placeholder: "\u0627\u0644\u0628\u0631\u064A\u062F \u0627\u0644\u0627\u0644\u0643\u062A\u0631\u0648\u0646\u064A"
                      }),
                      createVNode(_component_VeeErrorMessage, {
                        class: "text-red-500",
                        name: "email"
                      })
                    ])
                  ])
                ]),
                createVNode("div", { class: "form-btn" }, [
                  createVNode("button", {
                    disabled: unref(btnloading),
                    class: "has-spinner",
                    type: "submit"
                  }, " \u0627\u0631\u0633\u0627\u0644 ", 8, ["disabled"])
                ])
              ])
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div></div>`);
    };
  }
};
const _sfc_setup$2 = _sfc_main$2.setup;
_sfc_main$2.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/contact/forms/Form1.vue");
  return _sfc_setup$2 ? _sfc_setup$2(props, ctx) : void 0;
};
const _sfc_main$1 = {
  __name: "Tabs",
  __ssrInlineRender: true,
  setup(__props) {
    const selectedTab = ref("tab1");
    return (_ctx, _push, _parent, _attrs) => {
      const _component_ContactFormsForm1 = _sfc_main$2;
      _push(`<section${ssrRenderAttrs(mergeProps({ class: "section" }, _attrs))}><div class="container"><h2>\u062A\u0648\u0627\u0635\u0644 \u0645\u0639\u0646\u0627</h2><p> \u0644\u0627 \u062A\u062A\u0631\u062F\u062F \u0641\u064A \u0645\u0634\u0627\u0631\u0643\u0629 \u0627\u0633\u062A\u0641\u0633\u0627\u0631\u0627\u062A\u0643 \u0648\u0645\u062E\u0627\u0648\u0641\u0643 \u0648\u0642\u0636\u0627\u064A\u0627\u0643 \u0648\u0645\u062C\u0627\u0644\u0627\u062A \u0627\u0644\u062A\u062D\u0633\u064A\u0646\u060C \u0627\u0644\u0645\u062C\u0627\u0645\u0644\u0627\u062A \u0623\u0648 \u0623\u064A \u0623\u0641\u0643\u0627\u0631 \u0623\u062E\u0631\u0649 </p><div><div id="tabs-content">`);
      if (unref(selectedTab) === "tab1") {
        _push(ssrRenderComponent(_component_ContactFormsForm1, null, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div></div></section>`);
    };
  }
};
const _sfc_setup$1 = _sfc_main$1.setup;
_sfc_main$1.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/contact/Tabs.vue");
  return _sfc_setup$1 ? _sfc_setup$1(props, ctx) : void 0;
};
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "contact-us",
  __ssrInlineRender: true,
  setup(__props) {
    useHead({
      title: "\u062A\u0648\u0627\u0635\u0644 \u0645\u0639\u0646\u0627"
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_ContactHero = __nuxt_component_0;
      const _component_ContactBranch = __nuxt_component_1;
      const _component_ContactTabs = _sfc_main$1;
      _push(`<main${ssrRenderAttrs(_attrs)}>`);
      _push(ssrRenderComponent(_component_ContactHero, null, null, _parent));
      _push(ssrRenderComponent(_component_ContactBranch, null, null, _parent));
      _push(ssrRenderComponent(_component_ContactTabs, null, null, _parent));
      _push(`</main>`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("pages/contact-us.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
//# sourceMappingURL=contact-us-C8QicSWq.mjs.map
