import { defineComponent, withAsyncContext, mergeProps, unref, withCtx, createTextVNode, toDisplayString, createBlock, createVNode, openBlock, Fragment, createCommentVNode, renderSlot, ref, reactive, computed, toValue, getCurrentInstance, onServerPrefetch, inject, provide, shallowRef, toRef, nextTick, useSSRContext } from 'vue';
import { u as useHead } from './v3-D__bBwor.mjs';
import { _ as __nuxt_component_0 } from './nuxt-link-D5MIpspg.mjs';
import { ssrRenderComponent, ssrInterpolate, ssrRenderSlot, ssrRenderAttrs, ssrRenderClass, ssrRenderAttr, ssrRenderStyle } from 'vue/server-renderer';
import { b as useI18n, u as useLocalePath, _ as _export_sfc, c as useNuxtApp, d as asyncDataDefaults, e as createError } from './server.mjs';
import { u as useToast, F as Form, a as Field } from './useToast-DixuLKfl.mjs';
import * as yup from 'yup';
import axios from 'axios';
import '../routes/renderer.mjs';
import 'vue-bundle-renderer/runtime';
import '../_/nitro.mjs';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'node:fs';
import 'node:url';
import 'ipx';
import 'node:path';
import 'node:crypto';
import 'unhead/server';
import 'devalue';
import 'unhead/utils';
import 'unhead/plugins';
import 'vue-router';

const DEBOUNCE_DEFAULTS = {
  trailing: true
};
function debounce(fn, wait = 25, options = {}) {
  options = { ...DEBOUNCE_DEFAULTS, ...options };
  if (!Number.isFinite(wait)) {
    throw new TypeError("Expected `wait` to be a finite number");
  }
  let leadingValue;
  let timeout;
  let resolveList = [];
  let currentPromise;
  let trailingArgs;
  const applyFn = (_this, args) => {
    currentPromise = _applyPromised(fn, _this, args);
    currentPromise.finally(() => {
      currentPromise = null;
      if (options.trailing && trailingArgs && !timeout) {
        const promise = applyFn(_this, trailingArgs);
        trailingArgs = null;
        return promise;
      }
    });
    return currentPromise;
  };
  return function(...args) {
    if (currentPromise) {
      if (options.trailing) {
        trailingArgs = args;
      }
      return currentPromise;
    }
    return new Promise((resolve) => {
      const shouldCallNow = !timeout && options.leading;
      clearTimeout(timeout);
      timeout = setTimeout(() => {
        timeout = null;
        const promise = options.leading ? leadingValue : applyFn(this, args);
        for (const _resolve of resolveList) {
          _resolve(promise);
        }
        resolveList = [];
      }, wait);
      if (shouldCallNow) {
        leadingValue = applyFn(this, args);
        resolve(leadingValue);
      } else {
        resolveList.push(resolve);
      }
    });
  };
}
async function _applyPromised(fn, _this, args) {
  return await fn.apply(_this, args);
}

const isDefer = (dedupe) => dedupe === "defer" || dedupe === false;
function useAsyncData(...args) {
  var _a2, _b, _c, _d, _e, _f, _g;
  var _a;
  const autoKey = typeof args[args.length - 1] === "string" ? args.pop() : void 0;
  if (_isAutoKeyNeeded(args[0], args[1])) {
    args.unshift(autoKey);
  }
  let [_key, _handler, options = {}] = args;
  const key = computed(() => toValue(_key));
  if (typeof key.value !== "string") {
    throw new TypeError("[nuxt] [useAsyncData] key must be a string.");
  }
  if (typeof _handler !== "function") {
    throw new TypeError("[nuxt] [useAsyncData] handler must be a function.");
  }
  const nuxtApp = useNuxtApp();
  (_a2 = options.server) != null ? _a2 : options.server = true;
  (_b = options.default) != null ? _b : options.default = getDefault;
  (_c = options.getCachedData) != null ? _c : options.getCachedData = getDefaultCachedData;
  (_d = options.lazy) != null ? _d : options.lazy = false;
  (_e = options.immediate) != null ? _e : options.immediate = true;
  (_f = options.deep) != null ? _f : options.deep = asyncDataDefaults.deep;
  (_g = options.dedupe) != null ? _g : options.dedupe = "cancel";
  options._functionName || "useAsyncData";
  nuxtApp._asyncData[key.value];
  const initialFetchOptions = { cause: "initial", dedupe: options.dedupe };
  if (!((_a = nuxtApp._asyncData[key.value]) == null ? void 0 : _a._init)) {
    initialFetchOptions.cachedData = options.getCachedData(key.value, nuxtApp, { cause: "initial" });
    nuxtApp._asyncData[key.value] = createAsyncData(nuxtApp, key.value, _handler, options, initialFetchOptions.cachedData);
  }
  const asyncData = nuxtApp._asyncData[key.value];
  asyncData._deps++;
  const initialFetch = () => nuxtApp._asyncData[key.value].execute(initialFetchOptions);
  const fetchOnServer = options.server !== false && nuxtApp.payload.serverRendered;
  if (fetchOnServer && options.immediate) {
    const promise = initialFetch();
    if (getCurrentInstance()) {
      onServerPrefetch(() => promise);
    } else {
      nuxtApp.hook("app:created", async () => {
        await promise;
      });
    }
  }
  const asyncReturn = {
    data: writableComputedRef(() => {
      var _a22;
      return (_a22 = nuxtApp._asyncData[key.value]) == null ? void 0 : _a22.data;
    }),
    pending: writableComputedRef(() => {
      var _a22;
      return (_a22 = nuxtApp._asyncData[key.value]) == null ? void 0 : _a22.pending;
    }),
    status: writableComputedRef(() => {
      var _a22;
      return (_a22 = nuxtApp._asyncData[key.value]) == null ? void 0 : _a22.status;
    }),
    error: writableComputedRef(() => {
      var _a22;
      return (_a22 = nuxtApp._asyncData[key.value]) == null ? void 0 : _a22.error;
    }),
    refresh: (...args2) => nuxtApp._asyncData[key.value].execute(...args2),
    execute: (...args2) => nuxtApp._asyncData[key.value].execute(...args2),
    clear: () => clearNuxtDataByKey(nuxtApp, key.value)
  };
  const asyncDataPromise = Promise.resolve(nuxtApp._asyncDataPromises[key.value]).then(() => asyncReturn);
  Object.assign(asyncDataPromise, asyncReturn);
  return asyncDataPromise;
}
function writableComputedRef(getter) {
  return computed({
    get() {
      var _a;
      return (_a = getter()) == null ? void 0 : _a.value;
    },
    set(value) {
      const ref2 = getter();
      if (ref2) {
        ref2.value = value;
      }
    }
  });
}
function useLazyAsyncData(...args) {
  const autoKey = typeof args[args.length - 1] === "string" ? args.pop() : void 0;
  if (_isAutoKeyNeeded(args[0], args[1])) {
    args.unshift(autoKey);
  }
  const [key, handler, options = {}] = args;
  return useAsyncData(key, handler, { ...options, lazy: true }, null);
}
function _isAutoKeyNeeded(keyOrFetcher, fetcher) {
  if (typeof keyOrFetcher === "string") {
    return false;
  }
  if (typeof keyOrFetcher === "object" && keyOrFetcher !== null) {
    return false;
  }
  if (typeof keyOrFetcher === "function" && typeof fetcher === "function") {
    return false;
  }
  return true;
}
function clearNuxtDataByKey(nuxtApp, key) {
  if (key in nuxtApp.payload.data) {
    nuxtApp.payload.data[key] = void 0;
  }
  if (key in nuxtApp.payload._errors) {
    nuxtApp.payload._errors[key] = asyncDataDefaults.errorValue;
  }
  if (nuxtApp._asyncData[key]) {
    nuxtApp._asyncData[key].data.value = void 0;
    nuxtApp._asyncData[key].error.value = asyncDataDefaults.errorValue;
    {
      nuxtApp._asyncData[key].pending.value = false;
    }
    nuxtApp._asyncData[key].status.value = "idle";
  }
  if (key in nuxtApp._asyncDataPromises) {
    if (nuxtApp._asyncDataPromises[key]) {
      nuxtApp._asyncDataPromises[key].cancelled = true;
    }
    nuxtApp._asyncDataPromises[key] = void 0;
  }
}
function pick(obj, keys) {
  const newObj = {};
  for (const key of keys) {
    newObj[key] = obj[key];
  }
  return newObj;
}
function createAsyncData(nuxtApp, key, _handler, options, initialCachedData) {
  var _a2;
  var _a;
  (_a2 = (_a = nuxtApp.payload._errors)[key]) != null ? _a2 : _a[key] = asyncDataDefaults.errorValue;
  const hasCustomGetCachedData = options.getCachedData !== getDefaultCachedData;
  const handler = _handler ;
  const _ref = options.deep ? ref : shallowRef;
  const hasCachedData = initialCachedData != null;
  const unsubRefreshAsyncData = nuxtApp.hook("app:data:refresh", async (keys) => {
    if (!keys || keys.includes(key)) {
      await asyncData.execute({ cause: "refresh:hook" });
    }
  });
  const asyncData = {
    data: _ref(hasCachedData ? initialCachedData : options.default()),
    pending: shallowRef(!hasCachedData),
    error: toRef(nuxtApp.payload._errors, key),
    status: shallowRef("idle"),
    execute: (opts = {}) => {
      var _a3, _b2;
      if (nuxtApp._asyncDataPromises[key]) {
        if (isDefer((_a3 = opts.dedupe) != null ? _a3 : options.dedupe)) {
          return nuxtApp._asyncDataPromises[key];
        }
        nuxtApp._asyncDataPromises[key].cancelled = true;
      }
      if (opts.cause === "initial" || nuxtApp.isHydrating) {
        const cachedData = "cachedData" in opts ? opts.cachedData : options.getCachedData(key, nuxtApp, { cause: (_b2 = opts.cause) != null ? _b2 : "refresh:manual" });
        if (cachedData != null) {
          nuxtApp.payload.data[key] = asyncData.data.value = cachedData;
          asyncData.error.value = asyncDataDefaults.errorValue;
          asyncData.status.value = "success";
          return Promise.resolve(cachedData);
        }
      }
      {
        asyncData.pending.value = true;
      }
      asyncData.status.value = "pending";
      const promise = new Promise(
        (resolve, reject) => {
          try {
            resolve(handler(nuxtApp));
          } catch (err) {
            reject(err);
          }
        }
      ).then(async (_result) => {
        if (promise.cancelled) {
          return nuxtApp._asyncDataPromises[key];
        }
        let result = _result;
        if (options.transform) {
          result = await options.transform(_result);
        }
        if (options.pick) {
          result = pick(result, options.pick);
        }
        nuxtApp.payload.data[key] = result;
        asyncData.data.value = result;
        asyncData.error.value = asyncDataDefaults.errorValue;
        asyncData.status.value = "success";
      }).catch((error) => {
        if (promise.cancelled) {
          return nuxtApp._asyncDataPromises[key];
        }
        asyncData.error.value = createError(error);
        asyncData.data.value = unref(options.default());
        asyncData.status.value = "error";
      }).finally(() => {
        if (promise.cancelled) {
          return;
        }
        {
          asyncData.pending.value = false;
        }
        delete nuxtApp._asyncDataPromises[key];
      });
      nuxtApp._asyncDataPromises[key] = promise;
      return nuxtApp._asyncDataPromises[key];
    },
    _execute: debounce((...args) => asyncData.execute(...args), 0, { leading: true }),
    _default: options.default,
    _deps: 0,
    _init: true,
    _hash: void 0,
    _off: () => {
      unsubRefreshAsyncData();
      asyncData._init = false;
      if (!hasCustomGetCachedData) {
        nextTick(() => {
          if (!asyncData._init) {
            clearNuxtDataByKey(nuxtApp, key);
            asyncData.execute = () => Promise.resolve();
            asyncData.data.value = asyncDataDefaults.value;
          }
        });
      }
    }
  };
  return asyncData;
}
const getDefault = () => asyncDataDefaults.value;
const getDefaultCachedData = (key, nuxtApp, ctx) => {
  if (nuxtApp.isHydrating) {
    return nuxtApp.payload.data[key];
  }
  if (ctx.cause !== "refresh:manual" && ctx.cause !== "refresh:hook") {
    return nuxtApp.static.data[key];
  }
};
const HeadComponentCtxSymbol = Symbol("head-component");
const TagPositionProps = {
  /**
   * @deprecated Use tagPosition
   */
  body: { type: Boolean, default: void 0 },
  tagPosition: { type: String }
};
const normalizeProps = (_props) => {
  const props = Object.fromEntries(
    Object.entries(_props).filter(([_, value]) => value !== void 0)
  );
  if (typeof props.body !== "undefined") {
    props.tagPosition = props.body ? "bodyClose" : "head";
  }
  if (typeof props.renderPriority !== "undefined") {
    props.tagPriority = props.renderPriority;
  }
  return props;
};
function useHeadComponentCtx() {
  return inject(HeadComponentCtxSymbol, createHeadComponentCtx, true);
}
function createHeadComponentCtx() {
  const prev = inject(HeadComponentCtxSymbol, null);
  if (prev) {
    return prev;
  }
  const input = reactive({});
  const entry = useHead(input);
  const ctx = { input, entry };
  provide(HeadComponentCtxSymbol, ctx);
  return ctx;
}
const globalProps = {
  accesskey: String,
  autocapitalize: String,
  autofocus: {
    type: Boolean,
    default: void 0
  },
  class: { type: [String, Object, Array], default: void 0 },
  contenteditable: {
    type: Boolean,
    default: void 0
  },
  contextmenu: String,
  dir: String,
  draggable: {
    type: Boolean,
    default: void 0
  },
  enterkeyhint: String,
  exportparts: String,
  hidden: {
    type: Boolean,
    default: void 0
  },
  id: String,
  inputmode: String,
  is: String,
  itemid: String,
  itemprop: String,
  itemref: String,
  itemscope: String,
  itemtype: String,
  lang: String,
  nonce: String,
  part: String,
  slot: String,
  spellcheck: {
    type: Boolean,
    default: void 0
  },
  style: { type: [String, Object, Array], default: void 0 },
  tabindex: String,
  title: String,
  translate: String,
  /**
   * @deprecated Use tagPriority
   */
  renderPriority: [String, Number],
  /**
   * Unhead prop to modify the priority of the tag.
   */
  tagPriority: { type: [String, Number] }
};
defineComponent({
  name: "NoScript",
  inheritAttrs: false,
  props: {
    ...globalProps,
    ...TagPositionProps,
    title: String
  },
  setup(props, { slots }) {
    const { input } = useHeadComponentCtx();
    input.noscript || (input.noscript = []);
    const idx = input.noscript.push({}) - 1;
    return () => {
      var _a;
      const noscript = normalizeProps(props);
      const slotVnodes = (_a = slots.default) == null ? void 0 : _a.call(slots);
      const textContent = slotVnodes ? slotVnodes.filter(({ children }) => children).map(({ children }) => children).join("") : "";
      if (textContent) {
        noscript.innerHTML = textContent;
      }
      input.noscript[idx] = noscript;
      return null;
    };
  }
});
defineComponent({
  name: "Link",
  inheritAttrs: false,
  props: {
    ...globalProps,
    ...TagPositionProps,
    as: String,
    crossorigin: String,
    disabled: Boolean,
    fetchpriority: String,
    href: String,
    hreflang: String,
    imagesizes: String,
    imagesrcset: String,
    integrity: String,
    media: String,
    prefetch: {
      type: Boolean,
      default: void 0
    },
    referrerpolicy: String,
    rel: String,
    sizes: String,
    title: String,
    type: String,
    /** @deprecated **/
    methods: String,
    /** @deprecated **/
    target: String
  },
  setup(props) {
    const { input } = useHeadComponentCtx();
    input.link || (input.link = []);
    const idx = input.link.push({}) - 1;
    return () => {
      input.link[idx] = normalizeProps(props);
      return null;
    };
  }
});
defineComponent({
  name: "Base",
  inheritAttrs: false,
  props: {
    ...globalProps,
    href: String,
    target: String
  },
  setup(props) {
    const { input } = useHeadComponentCtx();
    return () => {
      input.base = normalizeProps(props);
      return null;
    };
  }
});
const Title = defineComponent({
  name: "Title",
  inheritAttrs: false,
  setup(_, { slots }) {
    const { input } = useHeadComponentCtx();
    return () => {
      var _a, _b, _c;
      const defaultSlot = (_a = slots.default) == null ? void 0 : _a.call(slots);
      input.title = ((_b = defaultSlot == null ? void 0 : defaultSlot[0]) == null ? void 0 : _b.children) ? String((_c = defaultSlot == null ? void 0 : defaultSlot[0]) == null ? void 0 : _c.children) : void 0;
      return null;
    };
  }
});
const Meta = defineComponent({
  name: "Meta",
  inheritAttrs: false,
  props: {
    ...globalProps,
    charset: String,
    content: String,
    httpEquiv: String,
    name: String,
    property: String
  },
  setup(props) {
    const { input } = useHeadComponentCtx();
    input.meta || (input.meta = []);
    const idx = input.meta.push({}) - 1;
    return () => {
      const meta = { "http-equiv": props.httpEquiv, ...normalizeProps(props) };
      if ("httpEquiv" in meta) {
        delete meta.httpEquiv;
      }
      input.meta[idx] = meta;
      return null;
    };
  }
});
defineComponent({
  name: "Style",
  inheritAttrs: false,
  props: {
    ...globalProps,
    ...TagPositionProps,
    type: String,
    media: String,
    nonce: String,
    title: String,
    /** @deprecated **/
    scoped: {
      type: Boolean,
      default: void 0
    }
  },
  setup(props, { slots }) {
    const { input } = useHeadComponentCtx();
    input.style || (input.style = []);
    const idx = input.style.push({}) - 1;
    return () => {
      var _a, _b, _c;
      const style = normalizeProps(props);
      const textContent = (_c = (_b = (_a = slots.default) == null ? void 0 : _a.call(slots)) == null ? void 0 : _b[0]) == null ? void 0 : _c.children;
      if (textContent) {
        input.style[idx] = style;
        style.textContent = textContent;
      }
      return null;
    };
  }
});
const Head = defineComponent({
  name: "Head",
  inheritAttrs: false,
  setup: (_props, ctx) => {
    createHeadComponentCtx();
    return () => {
      var _a, _b;
      return (_b = (_a = ctx.slots).default) == null ? void 0 : _b.call(_a);
    };
  }
});
const Html = defineComponent({
  name: "Html",
  inheritAttrs: false,
  props: {
    ...globalProps,
    manifest: String,
    version: String,
    xmlns: String
  },
  setup(_props, ctx) {
    const { input } = useHeadComponentCtx();
    return () => {
      var _a, _b;
      input.htmlAttrs = { ..._props, ...ctx.attrs };
      return (_b = (_a = ctx.slots).default) == null ? void 0 : _b.call(_a);
    };
  }
});
const Body = defineComponent({
  name: "Body",
  inheritAttrs: false,
  props: globalProps,
  setup(_props, ctx) {
    const { input } = useHeadComponentCtx();
    return () => {
      var _a, _b;
      input.bodyAttrs = { ..._props, ...ctx.attrs };
      return (_b = (_a = ctx.slots).default) == null ? void 0 : _b.call(_a);
    };
  }
});
const _sfc_main$3 = {};
function _sfc_ssrRender(_ctx, _push, _parent, _attrs) {
  _push(`<svg${ssrRenderAttrs(mergeProps({
    xmlns: "http://www.w3.org/2000/svg",
    width: "500",
    viewBox: "0 0 500 190.7"
  }, _attrs))}><path d="M351.7 21.1h-96.6v22.1h36.7v97.7H315V43.2h36.7V21.1zM427.6 17.9l-2.3-.3-2.3-.2-2.4-.1-2.4-.1-6.7.4-6.6.9-6.3 1.5-6.1 2.1-5.8 2.6-5.4 3.1-5.1 3.6-4.7 4-4.2 4.4-3.8 4.8-3.4 5.1-2.7 5.4-2.3 5.7-1.6 6-1 6.1-.3 6.3.4 7.5 1.4 7.2 2.3 6.9 3 6.6 16.6-15.9-.8-3-.6-3-.4-3.1-.1-3.2v-.8l.1-1.7h-.1l.1-.1 1.1-6.8 2.1-6.4 3.3-6 4.1-5.3 5-4.6 5.7-3.8 6.4-3 6.8-2 19-20.8z"></path><path d="m494.2 2.8-58.8 16.4-44.3 48.5 22.3-3-43.9 42 17.5-2.6-42.7 49.2 32.7-24.2 5.7 3.5 6.1 3 6.5 2.4 6.7 1.8 7.1 1.1 7.2.3 6.8-.3 6.5-.9 6.4-1.5 6-2.1 5.8-2.6 5.5-3.2 5-3.5 4.7-4 4.3-4.4 3.8-4.8 3.3-5.1 2.8-5.4 2.2-5.7 1.6-6 1-6.1.4-6.4-.5-6.1-1.3-7.1-2.1-7.3-2.8-7.1-3.5-6-4.2-4.5-7.4.8v37.3l-.5 6.2-1.4 5.8-2.2 5.5-3.1 5.1-3.7 4.7-4.3 4.1-5 3.5-5.4 2.8-5.9 2.1-6.2 1.3-6.6.5-5.6-.4-5.5-1-5.2-1.6-4.9-2.1 15.6-11.6 22.4-16.6 6.4-4.7-25.1 4.7 27.4-22.8 10.9-9.1 3.3 5.3 2.5 5.7 1.5 6.2.6 6.4V41.9L443 43.8l51.2-41z"></path><path style="${ssrRenderStyle({ "stroke-width": "0" })}" d="M5.8 119h101.3v22H5.8zM5.8 69.6H71v22H5.8zM5.8 21h101.3v22H5.8z"></path><path d="M205.7 118.8h-61.5V21h-23.1v119.8h84.6v-22z"></path><path style="${ssrRenderStyle({ "stroke-width": "0" })}" d="M218.6 21h23.3v119.9h-23.3zM5.8 21h23.3v119.9H5.8z"></path><path d="M447.2 171h-9.4l-1.8.1-5.9 3.3-2.4 6.5.1 1.6 3.6 4.6 3.2.6h9.4l.5-2.9h-9.3l-1.2-.1-3.4-4.2.1-1.1 3.3-4.7 3.3-.8h9.3l.6-2.9zM464.4 171H450l-3.2 16.7h14.3l.6-2.9h-11.5l2.1-10.9h11.5l.6-2.9z"></path><path d="M462.3 177.7h-9.5l-.6 3h9.5l.6-3zM415.6 176.1h-4.3l8.6 10.8.6.6.5.4h1.3l.5-.6.9-4.7h-2.9l-5.2-6.5z"></path><path d="M411.2 171h-.9l-.3.1-.6.6-.1.3-.1.4-3 15.3h2.9l2.2-11.6h4.3l-3.9-4.9-.5-.2zM425.9 171H423l-2.2 11.6h2.9l2.2-11.6zM406.1 171h-14.4l-3.2 16.7h14.3l.6-2.9h-11.5l2.1-10.9h11.5l.6-2.9z"></path><path d="M404 177.7h-9.5l-.6 3h9.5l.6-3zM366.3 171h-14.4l-3.2 16.7h14.4l.5-2.9h-11.5l2.1-10.9h11.5l.6-2.9zM333.5 171h-14.3l-3.3 16.7h2.9l2.7-13.8H333l.5-2.9zM349.3 171H335l-3.3 16.7h2.9l2.7-13.8h11.5l.5-2.9zM387.1 173.9H381l1.7.2 1.1.5.6 1v1.4l-.2 1-.6.8-.9.6-.9.4-.9.3H372l-.5 2.9h6.2l3.8 4.7h4.2l-4-5 1-.4 1-.4 3.7-4.8.1-1.5-.1-1.3-.3-.4z"></path><path d="M381.1 171h-11.9l-3.2 16.7h2.9l2.6-13.8h15.6l-4.5-2.9h-1.5zM331.5 177.7H322l-.6 3h9.5l.6-3zM347.3 177.7h-9.5l-.6 3h9.5l.6-3zM364.2 177.7h-9.5l-.5 3h9.4l.6-3zM315.3 171h-2.9l-3.3 16.7h2.9l3.3-16.7zM301.1 171h-9.4l-3.2 16.7h9.4l1.8-.2 1.6-.4 1.6-.8 1.5-1 .5-.5H292l2.1-10.9h13.1l-.5-.7-1-1-1.3-.7-1.5-.4-1.8-.1z"></path><path d="M307.2 173.9h-6.6l1.1.1 1 .3 2.4 3.9-.1 1.2-3.3 4.5-3.2.9h6.4l3-5.7.2-1.7-.1-1.6-.5-1.4-.3-.5zM280.2 171h-14.4l-3.2 16.7H277l.5-2.9h-11.4l2.1-10.9h11.4l.6-2.9zM236.8 173.9H234l-2.7 13.8h2.9l2.6-13.8zM248.9 171H246l-3.2 16.7h2.9l3.2-16.7zM262.9 171H260l-1.3 6.8h-9.8l-.6 2.9h9.8l-1.3 7h2.9l3.2-16.7z"></path><path d="M278.1 177.7h-9.5l-.5 3h9.5l.5-3zM244 171h-16l-.6 2.9h16l.6-2.9zM200.9 171h-9.4l-1.8.1-5.9 3.3-2.4 6.5.1 1.6 3.6 4.6 3.2.6h9.4l.5-2.9h-9.4l-1.1-.1-3.4-4.2.1-1.1 3.3-4.7 3.2-.8h9.4l.6-2.9zM218 171h-14.3l-3.3 16.7h14.4l.6-2.9h-11.5l2.1-10.9h11.5l.5-2.9z"></path><path d="M216 177.7h-9.5l-.6 3h9.5l.6-3zM169.3 176.1H165l8.6 10.8.5.6.6.4h1.3l.4-.6.2-1 .7-3.7h-2.8l-5.2-6.5z"></path><path d="M164.9 171h-.9l-.4.1-.2.3-.3.3-.2.3v.4l-3 15.3h2.9l2.2-11.6h4.3l-3.9-4.9-.5-.2zM179.6 171h-2.9l-2.2 11.6h2.8l2.3-11.6zM159.7 171h-14.3l-3.3 16.7h14.4l.6-2.9h-11.5l2.1-10.9h11.5l.5-2.9z"></path><path d="M157.7 177.7h-9.5l-.6 3h9.5l.6-3zM141.5 171h-2.9l-3.3 16.7h2.9l3.3-16.7zM59.8 171h-4.1l6.5 8.4-9.7 8.3h4.2l7-6.1h4.2l-1.8-2.3 2.6-2.2h-4.1l-4.8-6.1z"></path><path d="M67.9 181.6h-4.2l4.7 6.1h4.2l-4.7-6.1zM112.7 171H98.3l-3.2 16.7h14.4l.5-2.9H98.5l2.1-10.9h11.5l.6-2.9zM53.2 171H38.9l-3.3 16.7H50l.6-2.9H39.1l2.1-10.9h11.5l.5-2.9zM133.5 173.9h-6.1l1.7.2 1.1.5.6 1v1.4l-.2 1-.6.8-.9.6-.9.4-.9.3h-8.9l-.5 2.9h6.2l3.8 4.7h4.2l-4-5 1-.4 1-.4 3.7-4.8.1-1.5-.1-1.3-.3-.4zM89.6 171h-12l-3.2 16.7h2.9l2.6-13.8h14.9l-3.9-2.8-1.3-.1z"></path><path d="M127.5 171h-11.9l-3.2 16.7h2.9l2.6-13.8h15.6L129 171h-1.5zM94.8 173.9h-4.4l.8.3 1 1.1-3 4.8h-8.7l-.6 2.9h7.3l1.4-.1 5.5-3.4 1.1-3.8-.2-1.2-.2-.6zM51.2 177.7h-9.5l-.6 3h9.5l.6-3zM110.6 177.7h-9.5l-.5 3h9.5l.5-3zM75.8 171h-4l-7.2 6.1h4.1l7.1-6.1z"></path></svg>`);
}
const _sfc_setup$3 = _sfc_main$3.setup;
_sfc_main$3.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/icons/Logo.vue");
  return _sfc_setup$3 ? _sfc_setup$3(props, ctx) : void 0;
};
const __nuxt_component_1 = /* @__PURE__ */ _export_sfc(_sfc_main$3, [["ssrRender", _sfc_ssrRender]]);
const _sfc_main$2 = {
  __name: "Header",
  __ssrInlineRender: true,
  setup(__props) {
    const { t } = useI18n();
    const localePath = useLocalePath();
    const mobileMenuOpen = ref(false);
    reactive({
      products: false,
      services: false
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_nuxt_link = __nuxt_component_0;
      const _component_icons_logo = __nuxt_component_1;
      _push(`<header${ssrRenderAttrs(mergeProps({ class: "header" }, _attrs))}><div class="main-nav items-center"><div class="brand">`);
      _push(ssrRenderComponent(_component_nuxt_link, {
        rel: "noopener noreferrer Elito",
        to: unref(localePath)("/")
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(_component_icons_logo, null, null, _parent2, _scopeId));
          } else {
            return [
              createVNode(_component_icons_logo)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div><nav id="navigation-menu" class="${ssrRenderClass([{ toggled: mobileMenuOpen.value }, "main-navigation"])}"><button class="menu-toggle" aria-controls="primary-menu"${ssrRenderAttr("aria-expanded", mobileMenuOpen.value.toString())}><span class="mobile-menu-icon bar-icon"></span></button><div class="menu-primary-container"><ul id="primary-menu" class="menu"><li class="menu-item">`);
      _push(ssrRenderComponent(_component_nuxt_link, {
        to: unref(localePath)("/about-us")
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(unref(t)("nav.aboutUs"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(unref(t)("nav.aboutUs")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</li><li class="menu-item">`);
      _push(ssrRenderComponent(_component_nuxt_link, {
        to: unref(localePath)("/passenger-vehicles")
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(unref(t)("nav.passengerVehicles"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(unref(t)("nav.passengerVehicles")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</li><li class="menu-item">`);
      _push(ssrRenderComponent(_component_nuxt_link, {
        to: unref(localePath)("/find-your-battery")
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(unref(t)("nav.findYourBattary"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(unref(t)("nav.findYourBattary")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</li><li class="menu-item">`);
      _push(ssrRenderComponent(_component_nuxt_link, {
        to: unref(localePath)("/contact-us")
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(unref(t)("nav.contact-us"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(unref(t)("nav.contact-us")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</li><li class="menu-item"><a href="https://www.elito.com" target="_blank">\u0645\u062A\u062C\u0631 \u0627\u0644\u064A\u062A\u0648</a></li></ul></div></nav></div></header>`);
    };
  }
};
const _sfc_setup$2 = _sfc_main$2.setup;
_sfc_main$2.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/Header.vue");
  return _sfc_setup$2 ? _sfc_setup$2(props, ctx) : void 0;
};
const _sfc_main$1 = {
  __name: "MainFooter",
  __ssrInlineRender: true,
  props: {
    settings: {
      required: true
    }
  },
  setup(__props) {
    const toast = useToast();
    const localePath = useLocalePath();
    const { t } = useI18n();
    const btnloading = ref(false);
    const initialValues = reactive({
      email: ""
    });
    const schema = yup.object().shape({
      email: yup.string().email("\u064A\u062C\u0628 \u0627\u0646 \u064A\u0643\u0648\u0646 \u0628\u0631\u064A\u062F\u0627 \u0635\u062D\u064A\u062D\u0627").required("\u0627\u0644\u0627\u064A\u0645\u064A\u0644 \u0645\u0637\u0644\u0648\u0628")
    });
    const submit = (values, actions) => {
      btnloading.value = true;
      axios.post("https://elito-admin.najidalqimam.sa/api/web/news-letter", values).then((res) => {
        toast.success({
          title: "",
          message: "\u062A\u0645 \u0627\u0644\u0627\u0634\u062A\u0631\u0627\u0643 \u0628\u0646\u062C\u0627\u062D"
        });
        actions.resetForm();
      }).catch(() => {
        toast.error({
          title: "\u062D\u062F\u062B \u062E\u0637\u0623",
          message: "\u0644\u0645 \u064A\u062A\u0645 \u0627\u0631\u0633\u0627\u0644 \u0627\u0644\u0637\u0644\u0628 \u0628\u0631\u062C\u0627\u0621 \u062D\u0627\u0648\u0644 \u0645\u0631\u0647 \u0627\u062E\u0631\u064A"
        });
      }).finally(() => {
        btnloading.value = false;
      });
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_nuxt_link = __nuxt_component_0;
      const _component_IconsLogo = __nuxt_component_1;
      const _component_VeeForm = Form;
      const _component_VeeField = Field;
      _push(`<footer${ssrRenderAttrs(mergeProps({ class: "footer mt-auto" }, _attrs))}><div class="footer-left"><div class="footer-logo">`);
      _push(ssrRenderComponent(_component_nuxt_link, {
        to: unref(localePath)("/")
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(_component_IconsLogo, null, null, _parent2, _scopeId));
          } else {
            return [
              createVNode(_component_IconsLogo)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div><div class="footer-subscribe"> \u0627\u0628\u0642 \u0639\u0644\u0649 \u0627\u0637\u0644\u0627\u0639 \u0628\u0623\u062D\u062F\u062B \u0627\u0644\u0645\u064A\u0632\u0627\u062A \u0648\u0627\u0644\u0625\u0635\u062F\u0627\u0631\u0627\u062A <div id="email-subscribe-container"><h4>\u0627\u0634\u062A\u0631\u0643 \u0641\u064A \u0627\u0644\u0646\u0634\u0631\u0629 \u0627\u0644\u0625\u062E\u0628\u0627\u0631\u064A\u0629 \u0644\u062F\u064A\u0646\u0627</h4>`);
      _push(ssrRenderComponent(_component_VeeForm, {
        "initial-values": unref(initialValues),
        onSubmit: submit,
        "aria-label": "Contact form",
        "validation-schema": unref(schema),
        id: "newsletter_signup"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(_component_VeeField, {
              type: "email",
              class: "newsletter-email",
              name: "email",
              placeholder: "\u0627\u0644\u0628\u0631\u064A\u062F \u0627\u0644\u0627\u0644\u0643\u062A\u0631\u0648\u0646\u064A"
            }, null, _parent2, _scopeId));
            _push2(`<input class="newsletter-submit" type="submit" value="\u0627\u0634\u062A\u0631\u0643"${_scopeId}>`);
          } else {
            return [
              createVNode(_component_VeeField, {
                type: "email",
                class: "newsletter-email",
                name: "email",
                placeholder: "\u0627\u0644\u0628\u0631\u064A\u062F \u0627\u0644\u0627\u0644\u0643\u062A\u0631\u0648\u0646\u064A"
              }),
              createVNode("input", {
                class: "newsletter-submit",
                type: "submit",
                value: "\u0627\u0634\u062A\u0631\u0643"
              })
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div></div></div><div class="footer-content"><div class="quick-connect">`);
      if (__props.settings.phone) {
        _push(`<div><label><span class="icon"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 300 300" style="${ssrRenderStyle({ "enable-background": "new 0 0 300 300" })}" xml:space="preserve"><path d="M218.1 136.1h-4c-3.1-32.7-30.7-58.4-64.2-58.4s-61.1 25.7-64.2 58.4h-4c-11.3 0-20.5 9.2-20.5 20.5v25.1c0 11.3 9.2 20.5 20.5 20.5h9.7c3.4 0 6.1-2.7 6.1-6.1v-53.9c0-28.8 23.5-52.3 52.3-52.3s52.3 23.5 52.3 52.3v53.9c0 4.6-3.7 8.3-8.3 8.3h-19.3c-2.1-3.3-5.7-5.6-9.9-5.6-6.4 0-11.7 5.2-11.7 11.7s5.2 11.7 11.7 11.7c4.2 0 7.9-2.3 9.9-5.6H194c9.2 0 16.9-6.1 19.5-14.4h4.7c11.3 0 20.5-9.2 20.5-20.5v-25.1c-.1-11.3-9.3-20.5-20.6-20.5M85.5 190h-3.6c-4.6 0-8.3-3.7-8.3-8.3v-25.1c0-4.6 3.7-8.3 8.3-8.3h3.6V190zm140.9-8.3c0 4.6-3.7 8.3-8.3 8.3h-3.6v-41.7h3.6c4.6 0 8.3 3.7 8.3 8.3v25.1z" style="${ssrRenderStyle({ "fill": "#ee2a24" })}"></path></svg></span><span>\u062E\u062F\u0645\u0629 \u0627\u0644\u0639\u0645\u0644\u0627\u0621 :</span></label><p><a${ssrRenderAttr("href", `tel:${__props.settings.phone}`)}><b>${ssrInterpolate(__props.settings.phone)}</b></a></p></div>`);
      } else {
        _push(`<!---->`);
      }
      if (__props.settings.email) {
        _push(`<div><label><span class="icon"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 300 300" style="${ssrRenderStyle({ "enable-background": "new 0 0 300 300" })}" xml:space="preserve"><path d="M285.3 298.4c0-5-2-9.7-5.5-13.2s-8.3-5.5-13.2-5.5H129.4c-5 0-9.7 2-13.2 5.5s-5.5 8.3-5.5 13.2v87.3c0 5 2 9.7 5.5 13.2s8.3 5.5 13.2 5.5h137.2c5 0 9.7-2 13.2-5.5s5.5-8.3 5.5-13.2v-87.3zm-12.5 11.1-65 40c-6 3.7-13.6 3.7-19.6 0l-65-40v76.1c0 1.7.7 3.2 1.8 4.4 1.2 1.2 2.8 1.8 4.4 1.8h137.2c1.7 0 3.2-.7 4.4-1.8 1.2-1.2 1.8-2.8 1.8-4.4v-76.1zm-.8-14.2c-.3-.5-.6-1-1.1-1.4-1.2-1.2-2.8-1.8-4.4-1.8H129.4c-1.7 0-3.2.7-4.4 1.8-.4.4-.8.9-1.1 1.4l70.8 43.6c2 1.2 4.5 1.2 6.5 0l70.8-43.6z" style="${ssrRenderStyle({ "fill-rule": "evenodd", "clip-rule": "evenodd", "fill": "#ee2a24" })}" transform="translate(-48 -192)"></path></svg></span><span>\u0627\u0644\u0628\u0631\u064A\u062F \u0627\u0644\u0627\u0644\u0643\u062A\u0631\u0648\u0646\u064A :</span></label><p><a${ssrRenderAttr("href", `mailto:${__props.settings.email}`)}>${ssrInterpolate(__props.settings.email)}</a></p></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div><div class="footer-nav"><div class="menu-footer-container"><ul id="footer-menu" class="menu"><li id="menu-item-2173" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-2173">`);
      _push(ssrRenderComponent(_component_nuxt_link, {
        to: unref(localePath)("/about-us")
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(unref(t)("nav.aboutUs"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(unref(t)("nav.aboutUs")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</li><li id="menu-item-2180" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-2180">`);
      _push(ssrRenderComponent(_component_nuxt_link, {
        to: unref(localePath)("/find-your-battery")
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(unref(t)("nav.findYourBattary"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(unref(t)("nav.findYourBattary")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</li><li id="menu-item-821" class="menu-item menu-item-type-custom menu-item-object-custom menu-item-821">`);
      _push(ssrRenderComponent(_component_nuxt_link, {
        to: unref(localePath)("/contact-us")
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(unref(t)("nav.contact-us"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(unref(t)("nav.contact-us")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</li></ul></div><div class="menu-footer-products-container"><ul id="footer-products" class="menu"><li id="menu-item-2176" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-2176">`);
      _push(ssrRenderComponent(_component_nuxt_link, {
        to: unref(localePath)("/passenger-vehicles")
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(unref(t)("nav.passengerVehicles"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(unref(t)("nav.passengerVehicles")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</li></ul></div></div><div class="footer-social"><label>\u0627\u0628\u0642 \u0639\u0644\u0649 \u0627\u062A\u0635\u0627\u0644</label><ul class="social-links"><li><a href="#"><svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" x="0" y="0" viewBox="0 0 300 300" style="${ssrRenderStyle({ "enable-background": "new 0 0 300 300" })}" xml:space="preserve"><path style="${ssrRenderStyle({ "fill": "currentColor" })}" d="M150 .5C67.4.5.5 67.4.5 150S67.4 299.5 150 299.5 299.5 232.6 299.5 150 232.6.5 150 .5zm0 288c-76.5 0-138.5-62-138.5-138.5S73.5 11.5 150 11.5s138.5 62 138.5 138.5-62 138.5-138.5 138.5z"></path><g id="XMLID_834_"><path style="${ssrRenderStyle({ "fill": "currentColor" })}" d="M115.2 154.8h16.1v66.5c0 1.3 1.1 2.4 2.4 2.4h27.4c1.3 0 2.4-1.1 2.4-2.4v-66.1H182c1.2 0 2.2-.9 2.4-2.1l2.8-24.5c.1-.7-.1-1.3-.6-1.9-.5-.5-1.1-.8-1.8-.8h-21.4v-15.3c0-4.6 2.5-7 7.4-7h14c1.3 0 2.4-1.1 2.4-2.4V78.8c0-1.3-1.1-2.4-2.4-2.4h-20.2c-3.3 0-15 .7-24.1 9.1-10.2 9.4-8.8 20.6-8.4 22.5v17.9h-16.9c-1.3 0-2.4 1.1-2.4 2.4v24.2c0 1.2 1.1 2.3 2.4 2.3z"></path></g></svg></a></li><li><a href="#"><svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" x="0" y="0" viewBox="0 0 300 300" style="${ssrRenderStyle({ "enable-background": "new 0 0 300 300" })}" xml:space="preserve"><path style="${ssrRenderStyle({ "fill": "currentColor" })}" d="M150 .5C67.4.5.5 67.4.5 150S67.4 299.5 150 299.5 299.5 232.6 299.5 150 232.6.5 150 .5zm0 288c-76.5 0-138.5-62-138.5-138.5S73.5 11.5 150 11.5s138.5 62 138.5 138.5-62 138.5-138.5 138.5z"></path><path style="${ssrRenderStyle({ "fill": "currentColor" })}" d="M193.5 76.3h-86c-17 0-30.7 13.8-30.7 30.7v86c0 17 13.8 30.7 30.7 30.7h86c17 0 30.7-13.8 30.7-30.7v-86c0-16.9-13.7-30.7-30.7-30.7z"></path><path style="${ssrRenderStyle({ "fill": "#1d1d1b" })}" d="M107.5 125.4h18.4V193h-18.4z"></path><ellipse style="${ssrRenderStyle({ "fill": "#1d1d1b" })}" cx="116.7" cy="106.8" rx="10.7" ry="10.8"></ellipse><path style="${ssrRenderStyle({ "fill": "#1d1d1b" })}" d="M199.6 193h-18.4v-34.4c0-20.7-24.6-19.1-24.6 0V193h-18.4v-67.6h18.4v10.8c8.6-15.9 43-17.1 43 15.2V193z"></path></svg></a></li><li><a href="#"><svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" x="0" y="0" viewBox="0 0 300 300" style="${ssrRenderStyle({ "enable-background": "new 0 0 300 300" })}" xml:space="preserve"><path style="${ssrRenderStyle({ "fill": "currentColor" })}" d="M150 .5C67.4.5.5 67.4.5 150S67.4 299.5 150 299.5 299.5 232.6 299.5 150 232.6.5 150 .5zm0 288c-76.5 0-138.5-62-138.5-138.5S73.5 11.5 150 11.5s138.5 62 138.5 138.5-62 138.5-138.5 138.5z"></path><path style="${ssrRenderStyle({ "fill": "currentColor" })}" d="M236.2 93.2c-2.8 1.3-5.8 2.3-8.7 3.2 3.5-4 6.2-8.7 7.9-13.8.4-1.2 0-2.4-1-3.2-.9-.8-2.3-.8-3.3-.2-6.3 3.8-13.2 6.4-20.3 8-7.2-7-17-11.1-27.1-11.1-21.4 0-38.7 17.4-38.7 38.7 0 1.7.1 3.4.3 5-26.5-2.3-51.2-15.4-68.1-36.1-.6-.7-1.5-1.1-2.5-1.1-1 .1-1.8.6-2.3 1.4-3.4 5.9-5.2 12.6-5.2 19.5 0 9.3 3.3 18.2 9.2 25.1-1.8-.6-3.5-1.4-5.2-2.3-.9-.5-2-.5-2.9 0-.9.5-1.4 1.4-1.5 2.5v.5c0 13.9 7.5 26.5 19 33.3-1-.1-2-.2-2.9-.4-1-.2-2 .2-2.7.9-.7.8-.9 1.8-.6 2.8 4.2 13.3 15.2 23 28.4 26-11 6.9-23.5 10.5-36.6 10.5-2.7 0-5.5-.2-8.2-.5-1.3-.2-2.6.6-3.1 1.9-.5 1.3 0 2.7 1.2 3.4 16.9 10.8 36.4 16.6 56.5 16.6 39.4 0 64.1-18.6 77.9-34.2 17.2-19.5 27-45.2 27-70.7v-3.2c6.8-5.1 12.6-11.3 17.3-18.4.7-1.1.6-2.5-.2-3.5-1.1-.8-2.5-1.2-3.6-.6z"></path></svg></a></li><li><a href="#"><svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" x="0" y="0" viewBox="0 0 300 300" style="${ssrRenderStyle({ "enable-background": "new 0 0 300 300" })}" xml:space="preserve"><path style="${ssrRenderStyle({ "fill": "currentColor" })}" d="M150 .5C67.4.5.5 67.4.5 150S67.4 299.5 150 299.5 299.5 232.6 299.5 150 232.6.5 150 .5zm0 288c-76.5 0-138.5-62-138.5-138.5S73.5 11.5 150 11.5s138.5 62 138.5 138.5-62 138.5-138.5 138.5z"></path><path style="${ssrRenderStyle({ "fill": "currentColor" })}" d="M233 108.4c-2-7.4-7.8-13.3-15.3-15.3-13.5-3.7-67.7-3.7-67.7-3.7s-54.2 0-67.7 3.6C75 95 69 101 67 108.4c-3.6 13.5-3.6 41.6-3.6 41.6s0 28.2 3.6 41.6c2 7.4 7.8 13.3 15.3 15.3 13.7 3.7 67.7 3.7 67.7 3.7s54.2 0 67.7-3.6c7.4-2 13.3-7.8 15.3-15.3 3.6-13.5 3.6-41.6 3.6-41.6s.1-28.2-3.6-41.7zm-100.2 67.5V124l45 25.9-45 26z"></path></svg></a></li><li><a href="#"><svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" x="0" y="0" viewBox="0 0 300 300" style="${ssrRenderStyle({ "enable-background": "new 0 0 300 300" })}" xml:space="preserve"><path style="${ssrRenderStyle({ "fill": "currentColor" })}" d="M150 .5C67.4.5.5 67.4.5 150S67.4 299.5 150 299.5 299.5 232.6 299.5 150 232.6.5 150 .5zm0 288c-76.5 0-138.5-62-138.5-138.5S73.5 11.5 150 11.5s138.5 62 138.5 138.5-62 138.5-138.5 138.5z"></path><path style="${ssrRenderStyle({ "fill": "currentColor" })}" d="M150 89.4c19.7 0 22.1.1 29.9.4 20 .9 29.4 10.4 30.3 30.3.4 7.8.4 10.1.4 29.9 0 19.7-.1 22.1-.4 29.9-.9 19.9-10.3 29.4-30.3 30.3-7.8.4-10.1.4-29.9.4-19.7 0-22.1-.1-29.9-.4-20.1-.9-29.4-10.5-30.3-30.3-.4-7.8-.4-10.1-.4-29.9 0-19.7.1-22.1.4-29.9.9-19.9 10.3-29.4 30.3-30.3 7.8-.3 10.2-.4 29.9-.4zm0-13.3c-20.1 0-22.6.1-30.5.4-26.9 1.2-41.8 16.1-43 43-.4 7.9-.4 10.4-.4 30.5s.1 22.6.4 30.5c1.2 26.9 16.1 41.8 43 43 7.9.4 10.4.4 30.5.4s22.6-.1 30.5-.4c26.8-1.2 41.8-16.1 43-43 .4-7.9.4-10.4.4-30.5s-.1-22.6-.4-30.5c-1.2-26.8-16.1-41.8-43-43-7.9-.4-10.4-.4-30.5-.4zm0 35.9c-21 0-38 17-38 38s17 38 38 38 38-17 38-38-17-38-38-38zm0 62.6c-13.6 0-24.6-11-24.6-24.6 0-13.6 11-24.6 24.6-24.6s24.6 11 24.6 24.6c0 13.6-11 24.6-24.6 24.6zm39.5-72.9c-4.9 0-8.9 4-8.9 8.9s4 8.9 8.9 8.9 8.9-4 8.9-8.9c-.1-5-4-8.9-8.9-8.9z"></path></svg></a></li></ul></div></div><div class="footer-copy"><div class="copyrights"> \xA9 ${ssrInterpolate((/* @__PURE__ */ new Date()).getFullYear())}, \u0625\u0644\u064A\u062A\u0648. \u062C\u0645\u064A\u0639 \u0627\u0644\u062D\u0642\u0648\u0642 \u0645\u062D\u0641\u0648\u0638\u0629. </div><ul class="copy-links"><li>\u0625\u062E\u0644\u0627\u0621 \u0627\u0644\u0645\u0633\u0624\u0648\u0644\u064A\u0629</li><li>\u0634\u0631\u0648\u0637 \u0627\u0644\u0627\u0633\u062A\u062E\u062F\u0627\u0645</li><li>\u0627\u0644\u062E\u0635\u0648\u0635\u064A\u0629</li></ul></div></footer>`);
    };
  }
};
const _sfc_setup$1 = _sfc_main$1.setup;
_sfc_main$1.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/MainFooter.vue");
  return _sfc_setup$1 ? _sfc_setup$1(props, ctx) : void 0;
};
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "default",
  __ssrInlineRender: true,
  async setup(__props) {
    let __temp, __restore;
    const { locale } = useI18n();
    async function getHomeData() {
      return await axios.get("https://elito-admin.najidalqimam.sa/api/web/settings").then((res) => res.data.data);
    }
    const { data: settings, status } = ([__temp, __restore] = withAsyncContext(() => useLazyAsyncData(
      "settings",
      () => getHomeData()
    )), __temp = await __temp, __restore(), __temp);
    return (_ctx, _push, _parent, _attrs) => {
      const _component_Html = Html;
      const _component_Head = Head;
      const _component_Title = Title;
      const _component_Meta = Meta;
      const _component_Body = Body;
      const _component_Header = _sfc_main$2;
      const _component_MainFooter = _sfc_main$1;
      _push(ssrRenderComponent(_component_Html, mergeProps({
        lang: unref(locale),
        dir: unref(locale) == "ar" ? "rtl" : "ltr"
      }, _attrs), {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            if (unref(settings) && unref(status) === "success") {
              _push2(ssrRenderComponent(_component_Head, null, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    if (unref(locale) == "ar") {
                      _push3(`<!--[-->`);
                      if (unref(settings).website_title_ar) {
                        _push3(ssrRenderComponent(_component_Title, null, {
                          default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                            if (_push4) {
                              _push4(`${ssrInterpolate(unref(settings).website_title_ar)}`);
                            } else {
                              return [
                                createTextVNode(toDisplayString(unref(settings).website_title_ar), 1)
                              ];
                            }
                          }),
                          _: 1
                        }, _parent3, _scopeId2));
                      } else {
                        _push3(`<!---->`);
                      }
                      if (unref(settings).keywords_ar) {
                        _push3(ssrRenderComponent(_component_Meta, {
                          name: "keywords",
                          content: unref(settings).keywords_ar
                        }, null, _parent3, _scopeId2));
                      } else {
                        _push3(`<!---->`);
                      }
                      if (unref(settings).meta_desc_ar) {
                        _push3(ssrRenderComponent(_component_Meta, {
                          name: "description",
                          content: unref(settings).meta_desc_ar
                        }, null, _parent3, _scopeId2));
                      } else {
                        _push3(`<!---->`);
                      }
                      if (unref(settings).meta_desc_ar) {
                        _push3(ssrRenderComponent(_component_Meta, {
                          name: "og:description",
                          content: unref(settings).meta_desc_ar
                        }, null, _parent3, _scopeId2));
                      } else {
                        _push3(`<!---->`);
                      }
                      if (unref(settings).meta_title_ar) {
                        _push3(ssrRenderComponent(_component_Meta, {
                          name: "title",
                          content: unref(settings).meta_title_ar
                        }, null, _parent3, _scopeId2));
                      } else {
                        _push3(`<!---->`);
                      }
                      if (unref(settings).meta_title_ar) {
                        _push3(ssrRenderComponent(_component_Meta, {
                          name: "og:title",
                          content: unref(settings).meta_title_ar
                        }, null, _parent3, _scopeId2));
                      } else {
                        _push3(`<!---->`);
                      }
                      _push3(`<!--]-->`);
                    } else {
                      _push3(`<!--[-->`);
                      if (unref(settings).website_title_en) {
                        _push3(ssrRenderComponent(_component_Title, null, {
                          default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                            if (_push4) {
                              _push4(`${ssrInterpolate(unref(settings).website_title_en)}`);
                            } else {
                              return [
                                createTextVNode(toDisplayString(unref(settings).website_title_en), 1)
                              ];
                            }
                          }),
                          _: 1
                        }, _parent3, _scopeId2));
                      } else {
                        _push3(`<!---->`);
                      }
                      if (unref(settings).keywords_en) {
                        _push3(ssrRenderComponent(_component_Meta, {
                          name: "keywords",
                          content: unref(settings).keywords_en
                        }, null, _parent3, _scopeId2));
                      } else {
                        _push3(`<!---->`);
                      }
                      if (unref(settings).meta_desc_en) {
                        _push3(ssrRenderComponent(_component_Meta, {
                          name: "description",
                          content: unref(settings).meta_desc_en
                        }, null, _parent3, _scopeId2));
                      } else {
                        _push3(`<!---->`);
                      }
                      if (unref(settings).meta_desc_en) {
                        _push3(ssrRenderComponent(_component_Meta, {
                          name: "og:description",
                          content: unref(settings).meta_desc_en
                        }, null, _parent3, _scopeId2));
                      } else {
                        _push3(`<!---->`);
                      }
                      if (unref(settings).meta_title_en) {
                        _push3(ssrRenderComponent(_component_Meta, {
                          name: "title",
                          content: unref(settings).meta_title_en
                        }, null, _parent3, _scopeId2));
                      } else {
                        _push3(`<!---->`);
                      }
                      if (unref(settings).meta_title_en) {
                        _push3(ssrRenderComponent(_component_Meta, {
                          name: "og:title",
                          content: unref(settings).meta_title_en
                        }, null, _parent3, _scopeId2));
                      } else {
                        _push3(`<!---->`);
                      }
                      _push3(`<!--]-->`);
                    }
                    _push3(ssrRenderComponent(_component_Meta, {
                      name: "image",
                      content: "~/assets/icons/logo.svg"
                    }, null, _parent3, _scopeId2));
                    _push3(ssrRenderComponent(_component_Meta, {
                      name: "og:image",
                      content: "~/assets/icons/logo.svg"
                    }, null, _parent3, _scopeId2));
                  } else {
                    return [
                      unref(locale) == "ar" ? (openBlock(), createBlock(Fragment, { key: 0 }, [
                        unref(settings).website_title_ar ? (openBlock(), createBlock(_component_Title, { key: 0 }, {
                          default: withCtx(() => [
                            createTextVNode(toDisplayString(unref(settings).website_title_ar), 1)
                          ]),
                          _: 1
                        })) : createCommentVNode("", true),
                        unref(settings).keywords_ar ? (openBlock(), createBlock(_component_Meta, {
                          key: 1,
                          name: "keywords",
                          content: unref(settings).keywords_ar
                        }, null, 8, ["content"])) : createCommentVNode("", true),
                        unref(settings).meta_desc_ar ? (openBlock(), createBlock(_component_Meta, {
                          key: 2,
                          name: "description",
                          content: unref(settings).meta_desc_ar
                        }, null, 8, ["content"])) : createCommentVNode("", true),
                        unref(settings).meta_desc_ar ? (openBlock(), createBlock(_component_Meta, {
                          key: 3,
                          name: "og:description",
                          content: unref(settings).meta_desc_ar
                        }, null, 8, ["content"])) : createCommentVNode("", true),
                        unref(settings).meta_title_ar ? (openBlock(), createBlock(_component_Meta, {
                          key: 4,
                          name: "title",
                          content: unref(settings).meta_title_ar
                        }, null, 8, ["content"])) : createCommentVNode("", true),
                        unref(settings).meta_title_ar ? (openBlock(), createBlock(_component_Meta, {
                          key: 5,
                          name: "og:title",
                          content: unref(settings).meta_title_ar
                        }, null, 8, ["content"])) : createCommentVNode("", true)
                      ], 64)) : (openBlock(), createBlock(Fragment, { key: 1 }, [
                        unref(settings).website_title_en ? (openBlock(), createBlock(_component_Title, { key: 0 }, {
                          default: withCtx(() => [
                            createTextVNode(toDisplayString(unref(settings).website_title_en), 1)
                          ]),
                          _: 1
                        })) : createCommentVNode("", true),
                        unref(settings).keywords_en ? (openBlock(), createBlock(_component_Meta, {
                          key: 1,
                          name: "keywords",
                          content: unref(settings).keywords_en
                        }, null, 8, ["content"])) : createCommentVNode("", true),
                        unref(settings).meta_desc_en ? (openBlock(), createBlock(_component_Meta, {
                          key: 2,
                          name: "description",
                          content: unref(settings).meta_desc_en
                        }, null, 8, ["content"])) : createCommentVNode("", true),
                        unref(settings).meta_desc_en ? (openBlock(), createBlock(_component_Meta, {
                          key: 3,
                          name: "og:description",
                          content: unref(settings).meta_desc_en
                        }, null, 8, ["content"])) : createCommentVNode("", true),
                        unref(settings).meta_title_en ? (openBlock(), createBlock(_component_Meta, {
                          key: 4,
                          name: "title",
                          content: unref(settings).meta_title_en
                        }, null, 8, ["content"])) : createCommentVNode("", true),
                        unref(settings).meta_title_en ? (openBlock(), createBlock(_component_Meta, {
                          key: 5,
                          name: "og:title",
                          content: unref(settings).meta_title_en
                        }, null, 8, ["content"])) : createCommentVNode("", true)
                      ], 64)),
                      createVNode(_component_Meta, {
                        name: "image",
                        content: "~/assets/icons/logo.svg"
                      }),
                      createVNode(_component_Meta, {
                        name: "og:image",
                        content: "~/assets/icons/logo.svg"
                      })
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
            } else {
              _push2(`<!---->`);
            }
            _push2(ssrRenderComponent(_component_Body, {
              dir: unref(locale) === "ar" ? "rtl" : "ltr"
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`<div class="flex flex-col min-h-[100vh] bg-white"${_scopeId2}>`);
                  _push3(ssrRenderComponent(_component_Header, null, null, _parent3, _scopeId2));
                  ssrRenderSlot(_ctx.$slots, "default", {}, null, _push3, _parent3, _scopeId2);
                  _push3(ssrRenderComponent(_component_MainFooter, { settings: unref(settings) }, null, _parent3, _scopeId2));
                  _push3(`</div>`);
                } else {
                  return [
                    createVNode("div", { class: "flex flex-col min-h-[100vh] bg-white" }, [
                      createVNode(_component_Header),
                      renderSlot(_ctx.$slots, "default"),
                      createVNode(_component_MainFooter, { settings: unref(settings) }, null, 8, ["settings"])
                    ])
                  ];
                }
              }),
              _: 3
            }, _parent2, _scopeId));
          } else {
            return [
              unref(settings) && unref(status) === "success" ? (openBlock(), createBlock(_component_Head, { key: 0 }, {
                default: withCtx(() => [
                  unref(locale) == "ar" ? (openBlock(), createBlock(Fragment, { key: 0 }, [
                    unref(settings).website_title_ar ? (openBlock(), createBlock(_component_Title, { key: 0 }, {
                      default: withCtx(() => [
                        createTextVNode(toDisplayString(unref(settings).website_title_ar), 1)
                      ]),
                      _: 1
                    })) : createCommentVNode("", true),
                    unref(settings).keywords_ar ? (openBlock(), createBlock(_component_Meta, {
                      key: 1,
                      name: "keywords",
                      content: unref(settings).keywords_ar
                    }, null, 8, ["content"])) : createCommentVNode("", true),
                    unref(settings).meta_desc_ar ? (openBlock(), createBlock(_component_Meta, {
                      key: 2,
                      name: "description",
                      content: unref(settings).meta_desc_ar
                    }, null, 8, ["content"])) : createCommentVNode("", true),
                    unref(settings).meta_desc_ar ? (openBlock(), createBlock(_component_Meta, {
                      key: 3,
                      name: "og:description",
                      content: unref(settings).meta_desc_ar
                    }, null, 8, ["content"])) : createCommentVNode("", true),
                    unref(settings).meta_title_ar ? (openBlock(), createBlock(_component_Meta, {
                      key: 4,
                      name: "title",
                      content: unref(settings).meta_title_ar
                    }, null, 8, ["content"])) : createCommentVNode("", true),
                    unref(settings).meta_title_ar ? (openBlock(), createBlock(_component_Meta, {
                      key: 5,
                      name: "og:title",
                      content: unref(settings).meta_title_ar
                    }, null, 8, ["content"])) : createCommentVNode("", true)
                  ], 64)) : (openBlock(), createBlock(Fragment, { key: 1 }, [
                    unref(settings).website_title_en ? (openBlock(), createBlock(_component_Title, { key: 0 }, {
                      default: withCtx(() => [
                        createTextVNode(toDisplayString(unref(settings).website_title_en), 1)
                      ]),
                      _: 1
                    })) : createCommentVNode("", true),
                    unref(settings).keywords_en ? (openBlock(), createBlock(_component_Meta, {
                      key: 1,
                      name: "keywords",
                      content: unref(settings).keywords_en
                    }, null, 8, ["content"])) : createCommentVNode("", true),
                    unref(settings).meta_desc_en ? (openBlock(), createBlock(_component_Meta, {
                      key: 2,
                      name: "description",
                      content: unref(settings).meta_desc_en
                    }, null, 8, ["content"])) : createCommentVNode("", true),
                    unref(settings).meta_desc_en ? (openBlock(), createBlock(_component_Meta, {
                      key: 3,
                      name: "og:description",
                      content: unref(settings).meta_desc_en
                    }, null, 8, ["content"])) : createCommentVNode("", true),
                    unref(settings).meta_title_en ? (openBlock(), createBlock(_component_Meta, {
                      key: 4,
                      name: "title",
                      content: unref(settings).meta_title_en
                    }, null, 8, ["content"])) : createCommentVNode("", true),
                    unref(settings).meta_title_en ? (openBlock(), createBlock(_component_Meta, {
                      key: 5,
                      name: "og:title",
                      content: unref(settings).meta_title_en
                    }, null, 8, ["content"])) : createCommentVNode("", true)
                  ], 64)),
                  createVNode(_component_Meta, {
                    name: "image",
                    content: "~/assets/icons/logo.svg"
                  }),
                  createVNode(_component_Meta, {
                    name: "og:image",
                    content: "~/assets/icons/logo.svg"
                  })
                ]),
                _: 1
              })) : createCommentVNode("", true),
              createVNode(_component_Body, {
                dir: unref(locale) === "ar" ? "rtl" : "ltr"
              }, {
                default: withCtx(() => [
                  createVNode("div", { class: "flex flex-col min-h-[100vh] bg-white" }, [
                    createVNode(_component_Header),
                    renderSlot(_ctx.$slots, "default"),
                    createVNode(_component_MainFooter, { settings: unref(settings) }, null, 8, ["settings"])
                  ])
                ]),
                _: 3
              }, 8, ["dir"])
            ];
          }
        }),
        _: 3
      }, _parent));
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layouts/default.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
//# sourceMappingURL=default-DX71MJeT.mjs.map
