import { defineComponent, unref, withCtx, createVNode, toDisplayString, Transition, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrRenderStyle, ssrRenderList, ssrRenderComponent, ssrInterpolate } from 'vue/server-renderer';
import { Disclosure, DisclosureButton, DisclosurePanel } from '@headlessui/vue';
import { u as useHead } from './v3-D__bBwor.mjs';
import './server.mjs';
import '../_/nitro.mjs';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'node:fs';
import 'node:url';
import 'ipx';
import 'node:path';
import 'node:crypto';
import 'vue-router';
import '../routes/renderer.mjs';
import 'vue-bundle-renderer/runtime';
import 'unhead/server';
import 'devalue';
import 'unhead/utils';
import 'unhead/plugins';

const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "index",
  __ssrInlineRender: true,
  setup(__props) {
    useHead({
      title: "\u0627\u0644\u0627\u0633\u0626\u0644\u0629 \u0627\u0644\u0634\u0627\u0626\u0639\u0629"
    });
    const faqs = [
      {
        question: "\u0645\u0627 \u0647\u064A \u0627\u0644\u0628\u0637\u0627\u0631\u064A\u0629\u061F \u0643\u064A\u0641 \u062A\u0639\u0645\u0644\u061F",
        answer: "<p>\u062A\u062E\u0632\u0646 \u0627\u0644\u0628\u0637\u0627\u0631\u064A\u0629 \u0627\u0644\u0637\u0627\u0642\u0629 \u0639\u0644\u0649 \u0634\u0643\u0644 \u0637\u0627\u0642\u0629 \u0643\u064A\u0645\u064A\u0627\u0626\u064A\u0629\u060C \u062A\u064F\u0637\u0644\u0642 \u0639\u0646\u062F \u0627\u0644\u0637\u0644\u0628 \u0643\u0643\u0647\u0631\u0628\u0627\u0621. \u064A\u0633\u062A\u062E\u062F\u0645 \u0646\u0638\u0627\u0645 \u0627\u0644\u0625\u0634\u0639\u0627\u0644 \u0641\u064A \u0627\u0644\u0633\u064A\u0627\u0631\u0629 \u0647\u0630\u0647 \u0627\u0644\u0637\u0627\u0642\u0629 \u0644\u062A\u0634\u063A\u064A\u0644 \u0627\u0644\u0645\u062D\u0631\u0643. \u0643\u0645\u0627 \u064A\u0645\u0643\u0646 \u0644\u0628\u0637\u0627\u0631\u064A\u0629 \u0627\u0644\u0633\u064A\u0627\u0631\u0629 \u062A\u0634\u063A\u064A\u0644 \u0627\u0644\u0645\u0635\u0627\u0628\u064A\u062D \u0648\u0627\u0644\u0645\u0644\u062D\u0642\u0627\u062A \u0627\u0644\u0643\u0647\u0631\u0628\u0627\u0626\u064A\u0629 \u0627\u0644\u0623\u062E\u0631\u0649. \u0641\u064A \u062D\u0627\u0644 \u062A\u0639\u0637\u0644 \u0633\u064A\u0631 \u0627\u0644\u0645\u0648\u0644\u062F\u060C \u0642\u062F \u062A\u062D\u062A\u0627\u062C \u0627\u0644\u0628\u0637\u0627\u0631\u064A\u0629 \u0623\u064A\u0636\u064B\u0627 \u0625\u0644\u0649 \u062A\u0634\u063A\u064A\u0644 \u0627\u0644\u0646\u0638\u0627\u0645 \u0627\u0644\u0643\u0647\u0631\u0628\u0627\u0626\u064A \u0644\u0644\u0633\u064A\u0627\u0631\u0629 \u0628\u0627\u0644\u0643\u0627\u0645\u0644 \u0644\u0641\u062A\u0631\u0629 \u0642\u0635\u064A\u0631\u0629.</p>"
      },
      {
        question: "\u0645\u0627 \u0647\u064A \u0627\u0644\u0633\u0639\u0629 \u0627\u0644\u0627\u062D\u062A\u064A\u0627\u0637\u064A\u0629\u061F",
        answer: "<p>\u0633\u0639\u0629 \u0627\u0644\u0627\u062D\u062A\u064A\u0627\u0637 (RC) \u0647\u064A \u062A\u0635\u0646\u064A\u0641 \u0635\u0646\u0627\u0639\u064A \u0644\u0644\u0628\u0637\u0627\u0631\u064A\u0627\u062A \u064A\u064F\u062D\u062F\u062F \u0642\u062F\u0631\u0629 \u0627\u0644\u0628\u0637\u0627\u0631\u064A\u0629 \u0639\u0644\u0649 \u062A\u0634\u063A\u064A\u0644 \u0645\u0631\u0643\u0628\u0629 \u0645\u0639 \u062A\u0639\u0637\u0644 \u0645\u0648\u0644\u062F \u0643\u0647\u0631\u0628\u0627\u0626\u064A \u0623\u0648 \u0633\u064A\u0631 \u0645\u0631\u0648\u062D\u0629. \u0647\u0630\u0627 \u0627\u0644\u062A\u0635\u0646\u064A\u0641 \u0647\u0648 \u0639\u062F\u062F \u0627\u0644\u062F\u0642\u0627\u0626\u0642 \u0627\u0644\u062A\u064A \u064A\u0645\u0643\u0646 \u0641\u064A\u0647\u0627 \u062A\u0641\u0631\u064A\u063A \u0634\u062D\u0646\u0629 \u0627\u0644\u0628\u0637\u0627\u0631\u064A\u0629 \u0639\u0646\u062F \u062F\u0631\u062C\u0629 \u062D\u0631\u0627\u0631\u0629 80 \u0641\u0647\u0631\u0646\u0647\u0627\u064A\u062A (23 \u062F\u0631\u062C\u0629 \u0645\u0626\u0648\u064A\u0629) \u0639\u0646\u062F 25 \u0623\u0645\u0628\u064A\u0631\u060C \u0645\u0639 \u0627\u0644\u062D\u0641\u0627\u0638 \u0639\u0644\u0649 \u062C\u0647\u062F 10.5 \u0641\u0648\u0644\u062A \u0644\u0628\u0637\u0627\u0631\u064A\u0629 12 \u0641\u0648\u0644\u062A. \u0643\u0644\u0645\u0627 \u0627\u0631\u062A\u0641\u0639 \u062A\u0635\u0646\u064A\u0641 \u0627\u0644\u0627\u062D\u062A\u064A\u0627\u0637\u060C \u0632\u0627\u062F\u062A \u0645\u062F\u0629 \u062A\u0634\u063A\u064A\u0644 \u0645\u0631\u0643\u0628\u062A\u0643 \u0641\u064A \u062D\u0627\u0644 \u062A\u0639\u0637\u0644 \u0645\u0648\u0644\u062F \u0627\u0644\u0643\u0647\u0631\u0628\u0627\u0621 \u0623\u0648 \u0633\u064A\u0631 \u0627\u0644\u0645\u0631\u0648\u062D\u0629.</p>"
      },
      {
        question: "\u0645\u0627 \u0647\u0648 CCA \u0641\u064A \u0627\u0644\u0628\u0637\u0627\u0631\u064A\u0629\u061F",
        answer: "<p>\u0623\u0645\u0628\u064A\u0631 \u0628\u062F\u0621 \u0627\u0644\u062A\u0634\u063A\u064A\u0644 \u0627\u0644\u0628\u0627\u0631\u062F (CCA) \u0647\u0648 \u0645\u0639\u064A\u0627\u0631 \u062F\u0648\u0644\u064A \u0644\u0642\u064A\u0627\u0633 \u0623\u062F\u0627\u0621 \u0627\u0644\u0628\u0637\u0627\u0631\u064A\u0629. \u064A\u064F\u0633\u062A\u062E\u062F\u0645 \u0623\u0645\u0628\u064A\u0631 \u0628\u062F\u0621 \u0627\u0644\u062A\u0634\u063A\u064A\u0644 \u0627\u0644\u0628\u0627\u0631\u062F \u0641\u064A \u0635\u0646\u0627\u0639\u0629 \u0627\u0644\u0628\u0637\u0627\u0631\u064A\u0627\u062A \u0644\u062A\u062D\u062F\u064A\u062F \u0642\u062F\u0631\u0629 \u0627\u0644\u0628\u0637\u0627\u0631\u064A\u0629 \u0639\u0644\u0649 \u062A\u0634\u063A\u064A\u0644 \u0627\u0644\u0645\u062D\u0631\u0643 \u0641\u064A \u062F\u0631\u062C\u0627\u062A \u0627\u0644\u062D\u0631\u0627\u0631\u0629 \u0627\u0644\u0628\u0627\u0631\u062F\u0629. \u0647\u0630\u0627 \u0627\u0644\u062A\u0635\u0646\u064A\u0641 \u0647\u0648 \u0639\u062F\u062F \u0627\u0644\u0623\u0645\u0628\u064A\u0631\u0627\u062A \u0627\u0644\u062A\u064A \u064A\u0645\u0643\u0646 \u0644\u0628\u0637\u0627\u0631\u064A\u0629 \u062C\u062F\u064A\u062F\u0629 \u0645\u0634\u062D\u0648\u0646\u0629 \u0628\u0627\u0644\u0643\u0627\u0645\u0644 \u062A\u0648\u0635\u064A\u0644\u0647\u0627 \u0639\u0646\u062F \u062F\u0631\u062C\u0629 \u062D\u0631\u0627\u0631\u0629 0 \u0641\u0647\u0631\u0646\u0647\u0627\u064A\u062A \u0644\u0645\u062F\u0629 30 \u062B\u0627\u0646\u064A\u0629\u060C \u0645\u0639 \u0627\u0644\u062D\u0641\u0627\u0638 \u0639\u0644\u0649 \u062C\u0647\u062F \u0644\u0627 \u064A\u0642\u0644 \u0639\u0646 7.2 \u0641\u0648\u0644\u062A\u060C \u0648\u0630\u0644\u0643 \u0644\u0628\u0637\u0627\u0631\u064A\u0629 12 \u0641\u0648\u0644\u062A (1.2 \u0641\u0648\u0644\u062A \u0644\u0643\u0644 \u062E\u0644\u064A\u0629). \u0643\u0644\u0645\u0627 \u0627\u0631\u062A\u0641\u0639 \u062A\u0635\u0646\u064A\u0641 CCA\u060C \u0632\u0627\u062F\u062A \u0642\u062F\u0631\u0629 \u0628\u062F\u0621 \u062A\u0634\u063A\u064A\u0644 \u0627\u0644\u0628\u0637\u0627\u0631\u064A\u0629.</p>"
      },
      {
        question: "\u0645\u0627 \u0627\u0644\u0645\u0642\u0635\u0648\u062F \u0628\u0640 SLI\u061F",
        answer: `<p>\u062A\u064F\u0645\u0643\u0651\u0646 SLI \u0645\u0646 \u062A\u0634\u063A\u064A\u0644 \u0627\u0644\u0645\u062D\u0631\u0643 (S)\u060C \u0648\u0627\u0644\u0625\u0636\u0627\u0621\u0629 (L)\u060C \u0648\u0627\u0644\u0625\u0634\u0639\u0627\u0644 (I) \u0641\u064A \u062A\u0637\u0628\u064A\u0642\u0627\u062A \u0627\u0644\u0633\u064A\u0627\u0631\u0627\u062A.</p>
    <p>
\u062A\u062E\u0632\u0651\u0646 \u0627\u0644\u0628\u0637\u0627\u0631\u064A\u0629 \u0627\u0644\u0637\u0627\u0642\u0629 \u0643\u064A\u0645\u064A\u0627\u0626\u064A\u064B\u0627\u060C \u0648\u064A\u0645\u0643\u0646 \u0627\u0633\u062A\u062E\u062F\u0627\u0645\u0647\u0627 \u0639\u0646\u062F \u0627\u0644\u0637\u0644\u0628 \u0643\u0643\u0647\u0631\u0628\u0627\u0621. \u064A\u0633\u062A\u062E\u062F\u0645 \u0646\u0638\u0627\u0645 \u0627\u0644\u0625\u0634\u0639\u0627\u0644 \u0641\u064A \u0627\u0644\u0633\u064A\u0627\u0631\u0629 \u0647\u0630\u0647 \u0627\u0644\u0637\u0627\u0642\u0629 \u0627\u0644\u0643\u0647\u0631\u0628\u0627\u0626\u064A\u0629 \u0644\u062A\u0634\u063A\u064A\u0644 \u0627\u0644\u0645\u062D\u0631\u0643\u060C \u0648\u062A\u0634\u063A\u064A\u0644 \u0627\u0644\u0645\u0635\u0627\u0628\u064A\u062D \u0648\u0627\u0644\u0645\u0644\u062D\u0642\u0627\u062A \u0627\u0644\u0623\u062E\u0631\u0649.</p>`
      },
      {
        question: "\u0645\u0627 \u0647\u064A \u0628\u0637\u0627\u0631\u064A\u0629 EFB\u061F",
        answer: "<p>\u062A\u064F\u0639\u062F \u0627\u0644\u0628\u0637\u0627\u0631\u064A\u0629 \u0627\u0644\u0645\u064F\u062D\u0633\u0651\u0646\u0629 \u0627\u0644\u0645\u063A\u0645\u0648\u0631\u0629 (EFB) \u0623\u0643\u062B\u0631 \u062A\u0637\u0648\u0631\u064B\u0627 \u0645\u0646 \u0628\u0637\u0627\u0631\u064A\u0627\u062A \u0627\u0644\u0631\u0635\u0627\u0635 \u0627\u0644\u062D\u0645\u0636\u064A\u0629 \u0627\u0644\u062A\u0642\u0644\u064A\u062F\u064A\u0629. \u0641\u0647\u064A \u062A\u0648\u0641\u0631 \u0645\u0648\u062B\u0648\u0642\u064A\u0629 \u0648\u0623\u062F\u0627\u0621\u064B \u0623\u0639\u0644\u0649 \u0645\u0642\u0627\u0631\u0646\u0629\u064B \u0628\u0628\u0637\u0627\u0631\u064A\u0627\u062A \u0627\u0644\u0631\u0635\u0627\u0635 \u0627\u0644\u062D\u0645\u0636\u064A\u0629 \u0627\u0644\u0642\u064A\u0627\u0633\u064A\u0629 \u0627\u0644\u0645\u064F\u0633\u062A\u062E\u062F\u0645\u0629 \u0641\u064A \u062A\u0637\u0628\u064A\u0642\u0627\u062A \u0627\u0644\u0633\u064A\u0627\u0631\u0627\u062A \u0648\u0627\u0644\u0645\u0631\u0643\u0628\u0627\u062A \u0627\u0644\u062A\u062C\u0627\u0631\u064A\u0629. \u0648\u0639\u0627\u062F\u0629\u064B \u0645\u0627 \u064A\u064F\u0646\u0635\u062D \u0628\u0627\u0633\u062A\u062E\u062F\u0627\u0645 \u0647\u0630\u0647 \u0627\u0644\u0628\u0637\u0627\u0631\u064A\u0627\u062A \u0641\u064A \u0627\u0644\u0645\u0631\u0643\u0628\u0627\u062A \u0627\u0644\u0645\u064F\u0632\u0648\u062F\u0629 \u0628\u062A\u0642\u0646\u064A\u0629 \u0627\u0644\u062A\u0634\u063A\u064A\u0644 \u0648\u0627\u0644\u0625\u064A\u0642\u0627\u0641.</p>"
      },
      {
        question: "\u0645\u0627 \u0647\u064A \u0628\u0637\u0627\u0631\u064A\u0629 AGM\u061F",
        answer: `<p>
  \u062A\u064F\u0635\u0646\u0639 \u0628\u0637\u0627\u0631\u064A\u0627\u062A AGM (\u062D\u0635\u064A\u0631\u0629 \u0627\u0644\u0632\u062C\u0627\u062C \u0627\u0644\u0645\u0645\u062A\u0635) \u0628\u0637\u0631\u064A\u0642\u0629 \u0645\u062E\u062A\u0644\u0641\u0629 \u0639\u0646 \u0627\u0644\u0628\u0637\u0627\u0631\u064A\u0627\u062A \u0627\u0644\u062A\u0642\u0644\u064A\u062F\u064A\u0629 \u0627\u0644\u0645\u063A\u0645\u0648\u0631\u0629. 
  \u062A\u062A\u0645\u064A\u0632 \u0628\u0645\u0642\u0627\u0648\u0645\u0629 \u062F\u0627\u062E\u0644\u064A\u0629 \u0645\u0646\u062E\u0641\u0636\u0629 \u062C\u062F\u0627\u064B\u060C \u0645\u0645\u0627 \u064A\u062C\u0639\u0644\u0647\u0627 \u0642\u0627\u062F\u0631\u0629 \u0639\u0644\u0649 \u062A\u0648\u0641\u064A\u0631 \u062A\u064A\u0627\u0631\u0627\u062A \u0639\u0627\u0644\u064A\u0629 \u0639\u0646\u062F \u0627\u0644\u0637\u0644\u0628 \u0648\u0639\u0645\u0631 \u0627\u0641\u062A\u0631\u0627\u0636\u064A \u0637\u0648\u064A\u0644.
  \u0643\u0645\u0627 \u0623\u0646\u0647\u0627 \u0644\u0627 \u062A\u062D\u062A\u0627\u062C \u0625\u0644\u0649 \u0635\u064A\u0627\u0646\u0629\u060C \u0648\u062A\u0648\u0641\u0631 \u0645\u0648\u062B\u0648\u0642\u064A\u0629 \u0643\u0647\u0631\u0628\u0627\u0626\u064A\u0629 \u0639\u0627\u0644\u064A\u0629\u060C \u0648\u0647\u064A \u0623\u062E\u0641 \u0648\u0632\u0646\u0627\u064B \u0645\u0646 \u0628\u0637\u0627\u0631\u064A\u0627\u062A \u0627\u0644\u0631\u0635\u0627\u0635 \u0627\u0644\u062D\u0645\u0636\u064A\u0629 \u0627\u0644\u0645\u063A\u0645\u0648\u0631\u0629.
</p>
`
      },
      {
        question: "\u0643\u064A\u0641 \u064A\u062A\u0645 \u0634\u062D\u0646 \u0627\u0644\u0628\u0637\u0627\u0631\u064A\u0629 \u0641\u064A \u0627\u0644\u0645\u0631\u0643\u0628\u0629\u061F \u0643\u064A\u0641 \u0623\u0634\u062D\u0646 \u0628\u0637\u0627\u0631\u064A\u062A\u064A\u061F",
        answer: `  <p>
    \u064A\u0642\u0648\u0645 \u0645\u0648\u0644\u062F \u0627\u0644\u0633\u064A\u0627\u0631\u0629 \u0628\u0634\u062D\u0646 \u0627\u0644\u0628\u0637\u0627\u0631\u064A\u0629 \u0639\u0646\u062F \u062A\u0634\u063A\u064A\u0644 \u0627\u0644\u0645\u062D\u0631\u0643. \u064A\u062C\u0628 \u0623\u0646 \u064A\u062A\u0631\u0627\u0648\u062D \u0627\u0644\u062C\u0647\u062F \u0627\u0644\u0643\u0647\u0631\u0628\u064A \u0627\u0644\u0645\u0642\u0627\u0633 \u0639\u0628\u0631 \u0623\u0637\u0631\u0627\u0641 \u0627\u0644\u0628\u0637\u0627\u0631\u064A\u0629 \u0628\u064A\u0646 13.8 \u064814.2 \u0641\u0648\u0644\u062A. 
    \u0641\u064A \u062D\u0627\u0644 \u0644\u0627\u062D\u0638\u062A \u0641\u0631\u0642\u064B\u0627 \u0639\u0646 \u0647\u0630\u0627 \u0627\u0644\u0646\u0637\u0627\u0642\u060C \u064A\u064F\u0641\u0636\u0644 \u0627\u0644\u062A\u0648\u0627\u0635\u0644 \u0645\u0639 \u0643\u0647\u0631\u0628\u0627\u0626\u064A \u0627\u0644\u0645\u0631\u0643\u0628\u0629 \u0623\u0648 \u0645\u0631\u0643\u0632 \u0627\u0644\u062E\u062F\u0645\u0629.
  </p>
  <p>
    \u0645\u0648\u0644\u062F\u0627\u062A \u0627\u0644\u0633\u064A\u0627\u0631\u0627\u062A \u062A\u0639\u062A\u0628\u0631 \u0634\u0648\u0627\u062D\u0646 \u0628\u0637\u0627\u0631\u064A\u0629 \u0623\u0633\u0627\u0633\u064A\u0629\u060C \u0648\u064A\u0645\u0643\u0646\u0647\u0627 \u0634\u062D\u0646 \u0627\u0644\u0628\u0637\u0627\u0631\u064A\u0629 \u0625\u0630\u0627 \u0644\u0645 \u062A\u0643\u0646 \u0645\u0641\u0631\u063A\u0629 \u0628\u0627\u0644\u0643\u0627\u0645\u0644. 
    \u0648\u0625\u0630\u0627 \u0643\u0627\u0646\u062A \u0628\u0637\u0627\u0631\u064A\u062A\u0643 \u0645\u0641\u0631\u063A\u0629 \u0628\u0634\u0643\u0644 \u0639\u0645\u064A\u0642\u060C \u064A\u064F\u0646\u0635\u062D \u0628\u0634\u062F\u0629 \u0628\u0627\u0644\u062A\u0648\u062C\u0647 \u0625\u0644\u0649 \u0623\u062D\u062F \u0634\u0631\u0643\u0627\u0621 \u0625\u0644\u064A\u062A\u0648 \u0627\u0644\u0645\u0639\u062A\u0645\u062F\u064A\u0646 \u0644\u0625\u062C\u0631\u0627\u0621 \u0639\u0645\u0644\u064A\u0629 \u0627\u0644\u0634\u062D\u0646.
  </p>`
      },
      {
        question: "\u0647\u0644 \u064A\u0633\u0628\u0628 \u0627\u0644\u0634\u062D\u0646 \u0627\u0644\u0632\u0627\u0626\u062F \u062A\u0644\u0641\u0627\u064B \u0644\u0644\u0628\u0637\u0627\u0631\u064A\u0629\u061F",
        answer: `<p>
  \u0646\u0639\u0645\u060C \u064A\u064F\u0639\u062F \u0627\u0644\u0634\u062D\u0646 \u0627\u0644\u0632\u0627\u0626\u062F \u0645\u0646 \u0623\u0647\u0645 \u0627\u0644\u0639\u0648\u0627\u0645\u0644 \u0627\u0644\u062A\u064A \u062A\u0624\u062B\u0631 \u0639\u0644\u0649 \u0639\u0645\u0631 \u0627\u0644\u0628\u0637\u0627\u0631\u064A\u0629. 
  \u0623\u062B\u0646\u0627\u0621 \u0627\u0644\u0634\u062D\u0646 \u0627\u0644\u0632\u0627\u0626\u062F\u060C \u064A\u0624\u062F\u064A \u0627\u0644\u062A\u064A\u0627\u0631 \u0627\u0644\u0632\u0627\u0626\u062F \u0625\u0644\u0649 \u062A\u0622\u0643\u0644 \u0623\u0643\u0627\u0633\u064A\u062F \u0635\u0641\u0627\u0626\u062D \u0627\u0644\u0628\u0637\u0627\u0631\u064A\u0629. 
  \u0643\u0645\u0627 \u064A\u0624\u062F\u064A \u0627\u0644\u0634\u062D\u0646 \u0627\u0644\u0632\u0627\u0626\u062F \u0625\u0644\u0649 \u062A\u0633\u062E\u064A\u0646 \u0627\u0644\u0628\u0637\u0627\u0631\u064A\u0629\u060C \u0645\u0645\u0627 \u064A\u062A\u0633\u0628\u0628 \u0641\u064A \u062A\u0628\u062E\u0631 \u0627\u0644\u0645\u0627\u0621 \u0645\u0646 \u0627\u0644\u0645\u062D\u0644\u0648\u0644 \u0627\u0644\u0643\u0647\u0631\u0628\u0627\u0626\u064A\u060C 
  \u0648\u0628\u0627\u0644\u062A\u0627\u0644\u064A \u0632\u064A\u0627\u062F\u0629 \u0627\u0644\u062D\u0627\u062C\u0629 \u0625\u0644\u0649 \u062A\u0639\u0628\u0626\u0629 \u0627\u0644\u0645\u0627\u0621 \u062F\u0627\u062E\u0644 \u0627\u0644\u0628\u0637\u0627\u0631\u064A\u0629 \u0628\u0634\u0643\u0644 \u0645\u062A\u0643\u0631\u0631.
</p>
`
      },
      {
        question: "\u0647\u0644 \u062A\u0641\u0631\u063A \u0627\u0644\u0628\u0637\u0627\u0631\u064A\u0629 \u0646\u0641\u0633\u0647\u0627 \u0639\u0646\u062F \u0639\u062F\u0645 \u0627\u0644\u0627\u0633\u062A\u062E\u062F\u0627\u0645\u061F",
        answer: `<p>
  \u0646\u0639\u0645\u060C \u062C\u0645\u064A\u0639 \u0627\u0644\u0628\u0637\u0627\u0631\u064A\u0627\u062A\u060C \u0628\u063A\u0636 \u0627\u0644\u0646\u0638\u0631 \u0639\u0646 \u062A\u0642\u0646\u064A\u062A\u0647\u0627\u060C \u062A\u0642\u0648\u0645 \u0628\u062A\u0641\u0631\u064A\u063A \u0646\u0641\u0633\u0647\u0627 \u062A\u0644\u0642\u0627\u0626\u064A\u064B\u0627 \u0645\u0639 \u0645\u0631\u0648\u0631 \u0627\u0644\u0648\u0642\u062A. 
  \u0648\u062A\u0639\u062A\u0645\u062F \u0633\u0631\u0639\u0629 \u0627\u0644\u062A\u0641\u0631\u064A\u063A \u0627\u0644\u0630\u0627\u062A\u064A \u0639\u0644\u0649 \u0646\u0648\u0639 \u0627\u0644\u0628\u0637\u0627\u0631\u064A\u0629 \u0648\u062F\u0631\u062C\u0629 \u0627\u0644\u062D\u0631\u0627\u0631\u0629. 
  \u064A\u0645\u0643\u0646\u0643 \u0627\u0644\u062A\u0648\u0627\u0635\u0644 \u0645\u0639 \u0627\u0644\u0645\u0648\u0632\u0639 \u0623\u0648 \u0627\u0644\u0634\u0631\u0643\u0629 \u0627\u0644\u0645\u0635\u0646\u0639\u0629 \u0644\u0645\u0639\u0631\u0641\u0629 \u0645\u062F\u0629 \u0627\u0644\u062A\u0641\u0631\u064A\u063A \u0627\u0644\u0630\u0627\u062A\u064A \u0627\u0644\u062E\u0627\u0635\u0629 \u0628\u0628\u0637\u0627\u0631\u064A\u062A\u0643.
</p>
`
      },
      {
        question: "\u0644\u0645\u0627\u0630\u0627 \u062A\u0641\u0631\u063A \u0628\u0637\u0627\u0631\u064A\u062A\u064A \u062E\u0644\u0627\u0644 \u0627\u0644\u0644\u064A\u0644\u061F",
        answer: `<p>
  \u0627\u0644\u0633\u062D\u0628 \u063A\u064A\u0631 \u0627\u0644\u0636\u0631\u0648\u0631\u064A \u0644\u0644\u062A\u064A\u0627\u0631 \u0642\u062F \u064A\u0624\u062F\u064A \u0625\u0644\u0649 \u062D\u062F\u0648\u062B \u062F\u0627\u0626\u0631\u0629 \u0642\u0635\u0631 \u062A\u062A\u0633\u0628\u0628 \u0641\u064A \u062A\u0641\u0631\u064A\u063A \u0627\u0644\u0628\u0637\u0627\u0631\u064A\u0629. 
  \u0628\u0627\u0644\u0625\u0636\u0627\u0641\u0629 \u0625\u0644\u0649 \u0630\u0644\u0643\u060C \u0642\u062F \u062A\u0624\u062F\u064A \u0645\u0634\u0643\u0644\u0627\u062A \u062A\u0634\u063A\u064A\u0644 \u0627\u0644\u0645\u062D\u0631\u0643 \u0625\u0644\u0649 \u062A\u0641\u0631\u064A\u063A \u063A\u064A\u0631 \u0645\u0628\u0631\u0631 \u0644\u0644\u0628\u0637\u0627\u0631\u064A\u0629 \u0623\u062B\u0646\u0627\u0621 \u0627\u0644\u062A\u0634\u063A\u064A\u0644. 
  \u062A\u062D\u0642\u0642 \u0645\u0646 \u0646\u0638\u0627\u0645 \u0627\u0644\u0634\u062D\u0646 \u0623\u0648 \u0623\u0633\u0644\u0627\u0643 \u0627\u0644\u0645\u0631\u0643\u0628\u0629 \u0644\u0644\u062A\u0623\u0643\u062F \u0645\u0646 \u0639\u062F\u0645 \u0648\u062C\u0648\u062F \u0643\u0627\u0628\u0644\u0627\u062A \u0645\u0631\u062A\u062E\u064A\u0629 \u0623\u0648 \u062A\u0627\u0644\u0641\u0629. 
  \u0642\u0645 \u0628\u0627\u0633\u062A\u0628\u062F\u0627\u0644 \u0623\u0648 \u0641\u0635\u0644 \u0627\u0644\u0643\u0627\u0628\u0644\u0627\u062A \u0627\u0644\u062A\u0627\u0644\u0641\u0629 \u0623\u0648 \u0627\u0644\u0628\u0627\u0644\u064A\u0629 \u0625\u0646 \u0648\u064F\u062C\u062F\u062A.
</p>
`
      },
      {
        question: "\u0644\u0645\u0627\u0630\u0627 \u062A\u062F\u0648\u0631 \u0627\u0644\u0633\u064A\u0627\u0631\u0629 \u0648\u0644\u0627 \u062A\u0639\u0645\u0644\u061F",
        answer: `<p>
  \u0642\u062F \u064A\u0648\u0627\u062C\u0647 \u0627\u0644\u0645\u062D\u0631\u0643 \u0635\u0639\u0648\u0628\u0629 \u0641\u064A \u0625\u0646\u062A\u0627\u062C \u0627\u0644\u0634\u0631\u0627\u0631\u0629\u060C \u0623\u0648 \u0641\u064A \u0627\u0644\u062D\u0635\u0648\u0644 \u0639\u0644\u0649 \u0627\u0644\u0648\u0642\u0648\u062F\u060C \u0623\u0648 \u0641\u064A \u062A\u0648\u0644\u064A\u062F \u0627\u0644\u0636\u063A\u0637. 
  \u0645\u0646 \u0623\u0643\u062B\u0631 \u0627\u0644\u0623\u0633\u0628\u0627\u0628 \u0634\u064A\u0648\u0639\u064B\u0627 \u0647\u064A \u0645\u0634\u0643\u0644\u0627\u062A \u0641\u064A \u0646\u0638\u0627\u0645 \u0627\u0644\u0625\u0634\u0639\u0627\u0644. 
  \u0643\u0645\u0627 \u0623\u0646 \u0627\u0646\u0633\u062F\u0627\u062F \u0641\u0644\u062A\u0631 \u0627\u0644\u0648\u0642\u0648\u062F \u0642\u062F \u064A\u0643\u0648\u0646 \u0633\u0628\u0628\u064B\u0627 \u0641\u064A \u0647\u0630\u0647 \u0627\u0644\u0645\u0634\u0643\u0644\u0629 \u0623\u064A\u0636\u064B\u0627.
</p>
`
      },
      {
        question: "\u0645\u0627 \u0627\u0644\u0630\u064A \u064A\u0624\u062F\u064A \u0625\u0644\u0649 \u062A\u0641\u0631\u064A\u063A \u0628\u0637\u0627\u0631\u064A\u0629 \u0627\u0644\u0633\u064A\u0627\u0631\u0629\u061F",
        answer: `
<div>\u0647\u0646\u0627\u0643 \u0645\u062C\u0645\u0648\u0639\u0629 \u0645\u0646 \u0627\u0644\u0645\u0634\u0627\u0643\u0644 \u0627\u0644\u062A\u064A \u0642\u062F \u062A\u0624\u062F\u064A \u0625\u0644\u0649 \u062A\u0641\u0631\u064A\u063A \u0628\u0637\u0627\u0631\u064A\u0629 \u0627\u0644\u0633\u064A\u0627\u0631\u0629\u060C \u0628\u0645\u0627 \u0641\u064A \u0630\u0644\u0643</div>
<ol>
<li>\u062A\u0631\u0643\u062A \u0645\u0635\u0627\u0628\u064A\u062D\u0643 \u0627\u0644\u0623\u0645\u0627\u0645\u064A\u0629 \u0645\u0636\u0627\u0621\u0629 \u0648\u0627\u0644\u0645\u062D\u0631\u0643 \u0645\u062A\u0648\u0642\u0641.</li>
<li>\u0647\u0646\u0627\u0643 \u0634\u064A\u0621 \u0645\u0627 \u064A\u0633\u0628\u0628 \u0633\u062D\u0628\u064B\u0627 \u063A\u064A\u0631 \u0636\u0631\u0648\u0631\u064A (\u062A\u0641\u0631\u064A\u063A\u0627\u062A \u063A\u064A\u0631 \u0636\u0631\u0648\u0631\u064A\u0629).</li>
<li>\u0648\u0635\u0644\u0627\u062A \u0627\u0644\u0628\u0637\u0627\u0631\u064A\u0629 \u0645\u0641\u0643\u0648\u0643\u0629 \u0623\u0648 \u0623\u0637\u0631\u0627\u0641\u0647\u0627 \u0645\u062A\u0622\u0643\u0644\u0629.</li>
<li>\u062A\u0642\u0648\u062F \u0644\u0645\u0633\u0627\u0641\u0627\u062A \u0642\u0635\u064A\u0631\u0629 \u062C\u062F\u064B\u0627.</li>
<li>\u0644\u0627 \u064A\u062A\u0645 \u0634\u062D\u0646 \u0627\u0644\u0628\u0637\u0627\u0631\u064A\u0629 \u0623\u062B\u0646\u0627\u0621 \u0627\u0644\u0642\u064A\u0627\u062F\u0629.</li>
<li>\u0639\u0645\u0631 \u0627\u0644\u0628\u0637\u0627\u0631\u064A\u0629 \u0645\u0633\u062A\u0647\u0644\u0643.</li>
</ol>`
      },
      {
        question: "\u0645\u0627 \u0647\u0648 \u0627\u0644\u062A\u0641\u0631\u064A\u063A \u0627\u0644\u0637\u0641\u064A\u0644\u064A\u061F",
        answer: `<p>\u064A\u062D\u062F\u062B \u0647\u0630\u0627 \u0628\u0633\u0628\u0628 \u0627\u0644\u062D\u0645\u0644 \u0627\u0644\u0643\u0647\u0631\u0628\u0627\u0626\u064A \u063A\u064A\u0631 \u0627\u0644\u0645\u0639\u062A\u0627\u062F \u0627\u0644\u0630\u064A \u064A\u0628\u0642\u0649 \u0628\u0639\u062F \u0625\u064A\u0642\u0627\u0641 \u062A\u0634\u063A\u064A\u0644 \u0627\u0644\u0645\u062D\u0631\u0643 \u0648\u0625\u064A\u0642\u0627\u0641 \u062A\u0634\u063A\u064A\u0644 \u0627\u0644\u0645\u0641\u062A\u0627\u062D.</p>`
      },
      {
        question: "\u0645\u0627 \u0627\u0644\u0630\u064A \u0642\u062F \u064A\u0633\u0628\u0628 \u062A\u0644\u0641 \u0627\u0644\u0645\u0648\u0644\u062F\u061F",
        answer: `<p>
  \u0627\u0644\u0645\u0648\u0644\u062F \u0647\u0648 \u0645\u0643\u0648\u0646 \u0623\u0633\u0627\u0633\u064A \u0641\u064A \u062A\u0634\u063A\u064A\u0644 \u0627\u0644\u0623\u0646\u0638\u0645\u0629 \u0627\u0644\u0643\u0647\u0631\u0628\u0627\u0626\u064A\u0629 \u0641\u064A \u0633\u064A\u0627\u0631\u062A\u0643. 
  \u0642\u062F \u062A\u0646\u0634\u0623 \u0645\u0634\u0643\u0644\u0627\u062A \u0627\u0644\u0628\u0637\u0627\u0631\u064A\u0629 \u0628\u0633\u0631\u0639\u0629 \u0646\u062A\u064A\u062C\u0629 \u0648\u062C\u0648\u062F \u062E\u0644\u0644 \u0641\u064A \u0627\u0644\u0645\u0648\u0644\u062F. 
  \u0625\u0630\u0627 \u0628\u062F\u0623 \u0627\u0644\u0645\u0648\u0644\u062F \u0628\u0627\u0644\u062A\u0644\u0641\u060C \u0641\u0644\u0646 \u064A\u062A\u0645\u0643\u0646 \u0645\u0646 \u0634\u062D\u0646 \u0627\u0644\u0628\u0637\u0627\u0631\u064A\u0629\u060C 
  \u0645\u0645\u0627 \u064A\u0624\u062F\u064A \u0625\u0644\u0649 \u0639\u062F\u0645 \u0642\u062F\u0631\u0629 \u0627\u0644\u0628\u0637\u0627\u0631\u064A\u0629 \u0639\u0644\u0649 \u062A\u0634\u063A\u064A\u0644 \u0627\u0644\u0633\u064A\u0627\u0631\u0629 \u0648\u0633\u062A\u062C\u062F \u0646\u0641\u0633\u0643 \u0639\u0627\u0644\u0642\u064B\u0627.
</p>
`
      }
    ];
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(_attrs)}><section class="hero-banner"><div class="banner-slide swiper-slide"><div class="banner-image"><div><img alt="" src="https://www.elito.com/wp-content/uploads/2024/04/faq-bg.jpg"></div><div class="banner-caption"><h1 style="${ssrRenderStyle({ "color": "#fff" })}">\u0627\u0644\u0623\u0633\u0626\u0644\u0629 \u0627\u0644\u0634\u0627\u0626\u0639\u0629</h1><p style="${ssrRenderStyle({ "color": "#fff" })}"> \u0627\u062D\u0635\u0644 \u0639\u0644\u0649 \u0625\u062C\u0627\u0628\u0627\u062A \u0644\u062C\u0645\u064A\u0639 \u0627\u0633\u062A\u0641\u0633\u0627\u0631\u0627\u062A\u0643 \u0627\u0644\u0645\u062A\u0639\u0644\u0642\u0629 \u0628\u0627\u0633\u062A\u0628\u062F\u0627\u0644 \u0627\u0644\u0628\u0637\u0627\u0631\u064A\u0629\u060C <br> \u0627\u0644\u0627\u0633\u062A\u062E\u062F\u0627\u0645 \u0648\u0627\u0644\u0635\u064A\u0627\u0646\u0629. </p></div></div></div></section><section class="section container"><!--[-->`);
      ssrRenderList(faqs, (faq, index) => {
        _push(ssrRenderComponent(unref(Disclosure), {
          key: index,
          as: "div",
          class: "faq-item"
        }, {
          default: withCtx(({ open }, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(ssrRenderComponent(unref(DisclosureButton), {
                as: "div",
                class: ["faq-question cursor-pointer", open ? " before:hidden" : ""]
              }, {
                default: withCtx((_, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(`<h3${_scopeId2}>${ssrInterpolate(index + 1)}. ${ssrInterpolate(faq.question)}</h3>`);
                  } else {
                    return [
                      createVNode("h3", null, toDisplayString(index + 1) + ". " + toDisplayString(faq.question), 1)
                    ];
                  }
                }),
                _: 2
              }, _parent2, _scopeId));
              _push2(``);
              _push2(ssrRenderComponent(unref(DisclosurePanel), {
                as: "div",
                class: "faq-answer"
              }, null, _parent2, _scopeId));
            } else {
              return [
                createVNode(unref(DisclosureButton), {
                  as: "div",
                  class: ["faq-question cursor-pointer", open ? " before:hidden" : ""]
                }, {
                  default: withCtx(() => [
                    createVNode("h3", null, toDisplayString(index + 1) + ". " + toDisplayString(faq.question), 1)
                  ]),
                  _: 2
                }, 1032, ["class"]),
                createVNode(Transition, {
                  "enter-active-class": "transition duration-100 ease-out",
                  "enter-from-class": "transform scale-95 opacity-0",
                  "enter-to-class": "transform scale-100 opacity-100",
                  "leave-active-class": "transition duration-75 ease-out",
                  "leave-from-class": "transform scale-100 opacity-100",
                  "leave-to-class": "transform scale-95 opacity-0"
                }, {
                  default: withCtx(() => [
                    createVNode(unref(DisclosurePanel), {
                      as: "div",
                      innerHTML: faq.answer,
                      class: "faq-answer"
                    }, null, 8, ["innerHTML"])
                  ]),
                  _: 2
                }, 1024)
              ];
            }
          }),
          _: 2
        }, _parent));
      });
      _push(`<!--]--></section></div>`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("pages/faqs/index.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
//# sourceMappingURL=index-DHRxtbvz.mjs.map
