import { ref, mergeProps, unref, withCtx, createVNode, toDisplayString, createBlock, openBlock, Fragment, renderList, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrRenderComponent, ssrRenderList, ssrRenderAttr, ssrInterpolate } from 'vue/server-renderer';
import { Swiper, SwiperSlide } from 'swiper/vue';

const passengerVehicles = [
  {
    title: "42B20L",
    sku: "AET-RR-00042B20L",
    link: "https://www.elito.com/products/42b20l/",
    image: "https://www.elito.com/wp-content/uploads/2024/05/B20-72M_42B20L.png",
    warranty: "https://www.elito.com/wp-content/uploads/2024/05/72-Months-Warranty_Icon.png"
  },
  {
    title: "42B20R",
    sku: "AET-RR-00042B20R",
    link: "https://www.elito.com/products/42b20r/",
    image: "https://www.elito.com/wp-content/uploads/2024/05/B20-72M_42B20R.png",
    warranty: "https://www.elito.com/wp-content/uploads/2024/05/72-Months-Warranty_Icon.png"
  },
  {
    title: "55B24LS",
    sku: "AET-RR-0055B24LS",
    link: "https://www.elito.com/products/55b24ls/",
    image: "https://www.elito.com/wp-content/uploads/2024/05/55B24LS_AET-RR-0055B24LS.webp",
    warranty: "https://www.elito.com/wp-content/uploads/2024/05/60-Months-Warranty_Icon.png"
  },
  {
    title: "38B20R",
    sku: "AET-RR-00038B20R",
    link: "https://www.elito.com/products/38b20r/",
    image: "https://www.elito.com/wp-content/uploads/2024/05/B20-60M_38B20R.png",
    warranty: "https://www.elito.com/wp-content/uploads/2024/05/60-Months-Warranty_Icon.png"
  },
  {
    title: "38B20L",
    sku: "AET-RR-00038B20L",
    link: "https://www.elito.com/products/38b20l/",
    image: "https://www.elito.com/wp-content/uploads/2024/05/B20-60M_38B20L.png",
    warranty: "https://www.elito.com/wp-content/uploads/2024/05/60-Months-Warranty_Icon.png"
  },
  {
    title: "42B20LBH",
    sku: "AET-RR-040B20LBH",
    link: "https://www.elito.com/products/42b20lbh/",
    image: "https://www.elito.com/wp-content/uploads/2024/05/B20-72M_42B20LBH.png",
    warranty: "https://www.elito.com/wp-content/uploads/2024/05/60-Months-Warranty_Icon.png"
  },
  {
    title: "90D23LBH",
    sku: "AET-RR-090D23LBH",
    link: "https://www.elito.com/products/90d23lbh/",
    image: "https://www.elito.com/wp-content/uploads/2024/05/BH90D23L.webp",
    warranty: "https://www.elito.com/wp-content/uploads/2024/05/60-Months-Warranty_Icon.png"
  },
  {
    title: "DIN45L",
    sku: "AET-RR-000DIN45L",
    link: "https://www.elito.com/products/din45l/",
    image: "https://www.elito.com/wp-content/uploads/2024/05/DIN45L_AET-RR-000DIN45L.webp",
    warranty: "https://www.elito.com/wp-content/uploads/2024/05/60-Months-Warranty_Icon.png"
  },
  {
    title: "DIN50R",
    sku: "AET-RR-000DIN50R",
    link: "https://www.elito.com/products/din50r/",
    image: "https://www.elito.com/wp-content/uploads/2024/05/H4-60M_DIN50R.png",
    warranty: "https://www.elito.com/wp-content/uploads/2024/05/60-Months-Warranty_Icon.png"
  },
  {
    title: "DIN50L",
    sku: "AET-RR-000DIN50L",
    link: "https://www.elito.com/products/din50l/",
    image: "https://www.elito.com/wp-content/uploads/2024/05/H4-60M_DIN50L.png",
    warranty: "https://www.elito.com/wp-content/uploads/2024/05/60-Months-Warranty_Icon.png"
  }
];
const Wheeler = [
  {
    title: "ET400LMF",
    sku: "AET-BB-0ET400LMF",
    link: "https://www.elito.com/products/et400lmf/",
    image: "https://www.elito.com/wp-content/uploads/2024/04/B20-24M_ET400LMF.png",
    warranty: "https://www.elito.com/wp-content/uploads/2024/05/24-Months-Warranty_Icon-1.png"
  },
  {
    title: "ET600LMF",
    sku: "AET-BB-0ET600LMF",
    link: "https://www.elito.com/products/et600lmf/",
    image: "https://www.elito.com/wp-content/uploads/2024/04/D26-24M-Auto_ET600LMF.png",
    warranty: "https://www.elito.com/wp-content/uploads/2024/05/24-Months-Warranty_Icon-1.png"
  },
  {
    title: "ET600RMF",
    sku: "AET-BB-0ET600RMF",
    link: "https://www.elito.com/products/et600rmf/",
    image: "https://www.elito.com/wp-content/uploads/2024/04/D26-24M-Auto_ET600RMF.png",
    warranty: "https://www.elito.com/wp-content/uploads/2024/05/24-Months-Warranty_Icon-1.png"
  },
  {
    title: "ET400RMF",
    sku: "AET-BB-0ET400RMF",
    link: "https://www.elito.com/products/et400rmf/",
    image: "https://www.elito.com/wp-content/uploads/2024/04/B20-24M_ET400RMF.png",
    warranty: "https://www.elito.com/wp-content/uploads/2024/05/24-Months-Warranty_Icon-1.png"
  },
  {
    title: "ET320RMF",
    sku: "AET-BB-0ET320RMF",
    link: "https://www.elito.com/products/et320rmf/",
    image: "https://www.elito.com/wp-content/uploads/2024/05/B19-18M_ET320RMF.png",
    warranty: "https://www.elito.com/wp-content/uploads/2024/05/24-Months-Warranty_Icon-1.png"
  }
];
const Special = [
  {
    title: "ET600LMF",
    sku: "AET-BB-0ET600LMF",
    link: "https://www.elito.com/products/et600lmf/",
    image: "https://www.elito.com/wp-content/uploads/2024/04/D26-24M-Auto_ET600LMF.png",
    warranty: "https://www.elito.com/wp-content/uploads/2024/05/24-Months-Warranty_Icon-1.png"
  },
  {
    title: "ET900LMF",
    sku: "AET-BB-0ET900LMF",
    link: "https://www.elito.com/products/et900lmf/",
    image: "https://www.elito.com/wp-content/uploads/2024/04/ET900LMF.webp",
    warranty: "https://www.elito.com/wp-content/uploads/2024/05/24-Months-Warranty_Icon-1.png"
  },
  {
    title: "ET900RMF",
    sku: "AET-BB-0ET900RMF",
    link: "https://www.elito.com/products/et900rmf/",
    image: "https://www.elito.com/wp-content/uploads/2024/04/ET900LMF.webp",
    warranty: "https://www.elito.com/wp-content/uploads/2024/05/24-Months-Warranty_Icon-1.png"
  },
  {
    title: "ET1000LMF",
    sku: "AET-BB-ET1000LMF",
    link: "https://www.elito.com/products/et1000lmf/",
    image: "https://www.elito.com/wp-content/uploads/2024/04/N100-24M_ET1000LMF.png",
    warranty: "https://www.elito.com/wp-content/uploads/2024/05/24-Months-Warranty_Icon-1.png"
  },
  {
    title: "ET1300RMF",
    sku: "AET-BB-ET1300RMF",
    link: "https://www.elito.com/products/et1300rmf/",
    image: "https://www.elito.com/wp-content/uploads/2024/05/N120-24M-BUS_ET1300RMF.png",
    warranty: "https://www.elito.com/wp-content/uploads/2024/05/24-Months-Warranty_Icon-1.png"
  },
  {
    title: "ET600RMF",
    sku: "AET-BB-0ET600RMF",
    link: "https://www.elito.com/products/et600rmf/",
    image: "https://www.elito.com/wp-content/uploads/2024/04/D26-24M-Auto_ET600RMF.png",
    warranty: "https://www.elito.com/wp-content/uploads/2024/05/24-Months-Warranty_Icon-1.png"
  },
  {
    title: "ET1000RMF",
    sku: "AET-BB-ET1000RMF",
    link: "https://www.elito.com/products/et1000rmf/",
    image: "https://www.elito.com/wp-content/uploads/2024/04/N100-24M_ET1000RMF.png",
    warranty: "https://www.elito.com/wp-content/uploads/2024/05/24-Months-Warranty_Icon-1.png"
  }
];
const Genset_on = [
  {
    title: "ET700RMF",
    sku: "AET-BB-0ET700RMF",
    link: "https://www.elito.com/products/et700rmf/",
    image: "https://www.elito.com/wp-content/uploads/2024/04/D26-24M-P_ET700RMF.png",
    warranty: "https://www.elito.com/wp-content/uploads/2024/05/24-Months-Warranty_Icon-1.png",
    isSpecial: true
  },
  {
    title: "ET900RMF",
    sku: "AET-BB-0ET900RMF",
    link: "https://www.elito.com/products/et900rmf/",
    image: "https://www.elito.com/wp-content/uploads/2024/04/ET900LMF.webp",
    warranty: "https://www.elito.com/wp-content/uploads/2024/05/24-Months-Warranty_Icon-1.png"
  },
  {
    title: "ET1300RMF",
    sku: "AET-BB-ET1300RMF",
    link: "https://www.elito.com/products/et1300rmf/",
    image: "https://www.elito.com/wp-content/uploads/2024/05/N120-24M-BUS_ET1300RMF.png",
    warranty: "https://www.elito.com/wp-content/uploads/2024/05/24-Months-Warranty_Icon-1.png"
  },
  {
    title: "ET1000RMF",
    sku: "AET-BB-ET1000RMF",
    link: "https://www.elito.com/products/et1000rmf/",
    image: "https://www.elito.com/wp-content/uploads/2024/04/N100-24M_ET1000RMF.png",
    warranty: "https://www.elito.com/wp-content/uploads/2024/05/24-Months-Warranty_Icon-1.png"
  }
];
const Tractors = [
  {
    title: "ET1000LMF",
    sku: "AET-BB-ET1000LMF",
    link: "https://www.elito.com/products/et1000lmf/",
    image: "https://www.elito.com/wp-content/uploads/2024/04/N100-24M_ET1000LMF.png",
    warranty: "https://www.elito.com/wp-content/uploads/2024/05/24-Months-Warranty_Icon-1.png"
  },
  {
    title: "ET900RMF",
    sku: "AET-BB-0ET900RMF",
    link: "https://www.elito.com/products/et900rmf/",
    image: "https://www.elito.com/wp-content/uploads/2024/04/ET900LMF.webp",
    warranty: "https://www.elito.com/wp-content/uploads/2024/05/24-Months-Warranty_Icon-1.png"
  },
  {
    title: "ET900LMF",
    sku: "AET-BB-0ET900LMF",
    link: "https://www.elito.com/products/et900lmf/",
    image: "https://www.elito.com/wp-content/uploads/2024/04/ET900LMF.webp",
    warranty: "https://www.elito.com/wp-content/uploads/2024/05/24-Months-Warranty_Icon-1.png"
  },
  {
    title: "ET800RMF",
    sku: "AET-BB-0ET800RMF",
    link: "https://www.elito.com/products/et800rmf/",
    image: "https://www.elito.com/wp-content/uploads/2024/04/D31-24M_ET800RMF.png",
    warranty: "https://www.elito.com/wp-content/uploads/2024/05/24-Months-Warranty_Icon-1.png"
  },
  {
    title: "ET800LMF",
    sku: "AET-BB-0ET800LMF",
    link: "https://www.elito.com/products/et800lmf/",
    image: "https://www.elito.com/wp-content/uploads/2024/04/D31-24M_ET800LMF.png",
    warranty: "https://www.elito.com/wp-content/uploads/2024/05/24-Months-Warranty_Icon-1.png"
  },
  {
    title: "ET700RMF",
    sku: "AET-BB-0ET700RMF",
    link: "https://www.elito.com/products/et700rmf/",
    image: "https://www.elito.com/wp-content/uploads/2024/04/D26-24M-P_ET700RMF.png",
    warranty: "https://www.elito.com/wp-content/uploads/2024/05/24-Months-Warranty_Icon-1.png"
  },
  {
    title: "ET700LMF",
    sku: "AET-BB-0ET700LMF",
    link: "https://www.elito.com/products/et700lmf/",
    image: "https://www.elito.com/wp-content/uploads/2024/04/D26-24M-P_ET700LMF.png",
    warranty: "https://www.elito.com/wp-content/uploads/2024/05/24-Months-Warranty_Icon-1.png"
  },
  {
    title: "ET600LMF",
    sku: "AET-BB-0ET600LMF",
    link: "https://www.elito.com/products/et600lmf/",
    image: "https://www.elito.com/wp-content/uploads/2024/04/D26-24M-Auto_ET600LMF.png",
    warranty: "https://www.elito.com/wp-content/uploads/2024/05/24-Months-Warranty_Icon-1.png"
  },
  {
    title: "ET600RMF",
    sku: "AET-BB-0ET600RMF",
    link: "https://www.elito.com/products/et600rmf/",
    image: "https://www.elito.com/wp-content/uploads/2024/04/D26-24M-Auto_ET600RMF.png",
    warranty: "https://www.elito.com/wp-content/uploads/2024/05/24-Months-Warranty_Icon-1.png"
  },
  {
    title: "ET1300RMF",
    sku: "AET-BB-ET1300RMF",
    link: "https://www.elito.com/products/et1300rmf/",
    image: "https://www.elito.com/wp-content/uploads/2024/05/N120-24M-BUS_ET1300RMF.png",
    warranty: "https://www.elito.com/wp-content/uploads/2024/05/24-Months-Warranty_Icon-1.png"
  }
];
const commercial = [
  {
    title: "ET1000LMF",
    sku: "AET-BB-ET1000LMF",
    link: "https://www.elito.com/products/et1000lmf/",
    image: "https://www.elito.com/wp-content/uploads/2024/04/N100-24M_ET1000LMF.png",
    warranty: "https://www.elito.com/wp-content/uploads/2024/05/24-Months-Warranty_Icon-1.png"
  },
  {
    title: "ET400LMF",
    sku: "AET-BB-0ET400LMF",
    link: "https://www.elito.com/products/et400lmf/",
    image: "https://www.elito.com/wp-content/uploads/2024/04/B20-24M_ET400LMF.png",
    warranty: "https://www.elito.com/wp-content/uploads/2024/05/24-Months-Warranty_Icon-1.png"
  },
  {
    title: "ET900RMF",
    sku: "AET-BB-0ET900RMF",
    link: "https://www.elito.com/products/et900rmf/",
    image: "https://www.elito.com/wp-content/uploads/2024/04/ET900LMF.webp",
    warranty: "https://www.elito.com/wp-content/uploads/2024/05/24-Months-Warranty_Icon-1.png"
  },
  {
    title: "ET900LMF",
    sku: "AET-BB-0ET900LMF",
    link: "https://www.elito.com/products/et900lmf/",
    image: "https://www.elito.com/wp-content/uploads/2024/04/ET900LMF.webp",
    warranty: "https://www.elito.com/wp-content/uploads/2024/05/24-Months-Warranty_Icon-1.png"
  },
  {
    title: "ET800RMF",
    sku: "AET-BB-0ET800RMF",
    link: "https://www.elito.com/products/et800rmf/",
    image: "https://www.elito.com/wp-content/uploads/2024/04/D31-24M_ET800RMF.png",
    warranty: "https://www.elito.com/wp-content/uploads/2024/05/24-Months-Warranty_Icon-1.png"
  },
  {
    title: "ET800LMF",
    sku: "AET-BB-0ET800LMF",
    link: "https://www.elito.com/products/et800lmf/",
    image: "https://www.elito.com/wp-content/uploads/2024/04/D31-24M_ET800LMF.png",
    warranty: "https://www.elito.com/wp-content/uploads/2024/05/24-Months-Warranty_Icon-1.png"
  },
  {
    title: "ET700RMF",
    sku: "AET-BB-0ET700RMF",
    link: "https://www.elito.com/products/et700rmf/",
    image: "https://www.elito.com/wp-content/uploads/2024/04/D26-24M-P_ET700RMF.png",
    warranty: "https://www.elito.com/wp-content/uploads/2024/05/24-Months-Warranty_Icon-1.png"
  },
  {
    title: "ET700LMF",
    sku: "AET-BB-0ET700LMF",
    link: "https://www.elito.com/products/et700lmf/",
    image: "https://www.elito.com/wp-content/uploads/2024/04/D26-24M-P_ET700LMF.png",
    warranty: "https://www.elito.com/wp-content/uploads/2024/05/24-Months-Warranty_Icon-1.png"
  },
  {
    title: "ET600RMF",
    sku: "AET-BB-0ET600RMF",
    link: "https://www.elito.com/products/et600rmf/",
    image: "https://www.elito.com/wp-content/uploads/2024/04/D26-24M-Auto_ET600RMF.png",
    warranty: "https://www.elito.com/wp-content/uploads/2024/05/24-Months-Warranty_Icon-1.png"
  },
  {
    title: "ET400RMF",
    sku: "AET-BB-0ET400RMF",
    link: "https://www.elito.com/products/et400rmf/",
    image: "https://www.elito.com/wp-content/uploads/2024/04/B20-24M_ET400RMF.png",
    warranty: "https://www.elito.com/wp-content/uploads/2024/05/24-Months-Warranty_Icon-1.png"
  }
];
const vehicles = [
  {
    id: 35,
    name: {
      en: "Passenger Vehicles",
      ar: "\u0645\u0631\u0643\u0628\u0627\u062A \u0627\u0644\u0631\u0643\u0627\u0628"
    },
    icon: "https://www.elito.com/wp-content/uploads/2024/05/Passenger_Vehicle.png",
    iconActive: "https://www.elito.com/wp-content/uploads/2024/05/Passenger_Vehicle_on.png",
    products: passengerVehicles
  },
  {
    id: 34,
    name: {
      en: "3 Wheeler",
      ar: "\u062B\u0644\u0627\u062B \u0639\u062C\u0644\u0627\u062A"
    },
    icon: "https://www.elito.com/wp-content/uploads/2024/05/Three_Wheeler.png",
    iconActive: "https://www.elito.com/wp-content/uploads/2024/05/Three_Wheeler_on.png",
    products: Wheeler
  },
  {
    id: 36,
    name: {
      en: "Commercial Vehicles",
      ar: "\u0627\u0644\u0645\u0631\u0643\u0628\u0627\u062A \u0627\u0644\u062A\u062C\u0627\u0631\u064A\u0629"
    },
    icon: "https://www.elito.com/wp-content/uploads/2024/05/Commercial_Vehicle.png",
    iconActive: "https://www.elito.com/wp-content/uploads/2024/05/Commercial_Vehicle_on.png",
    products: commercial
  },
  {
    id: 38,
    name: {
      en: "Tractors",
      ar: "\u062C\u0631\u0627\u0631\u0627\u062A"
    },
    icon: "https://www.elito.com/wp-content/uploads/2024/05/Tractor.png",
    iconActive: "https://www.elito.com/wp-content/uploads/2024/05/Tractor_on.png",
    products: Tractors
  },
  {
    id: 37,
    name: {
      en: "Genset",
      ar: "\u0645\u0648\u0644\u062F \u0643\u0647\u0631\u0628\u0627\u0621"
    },
    icon: "https://www.elito.com/wp-content/uploads/2024/05/Genset.png",
    iconActive: "https://www.elito.com/wp-content/uploads/2024/05/Genset_on.png",
    products: Genset_on
  },
  {
    id: 65,
    name: {
      en: "Special Vehicles",
      ar: "\u0645\u0631\u0643\u0628\u0627\u062A \u062E\u0627\u0635\u0629"
    },
    icon: "https://www.elito.com/wp-content/uploads/2024/05/Special_Vehicales.png",
    iconActive: "https://www.elito.com/wp-content/uploads/2024/05/Special_Vehicales_on.png",
    products: Special
  }
];
const _sfc_main = {
  __name: "prod",
  __ssrInlineRender: true,
  setup(__props) {
    const breakpoints1 = {
      300: {
        slidesPerView: 1,
        spaceBetween: 10
      },
      600: {
        slidesPerView: 2,
        spaceBetween: 10
      },
      992: {
        slidesPerView: 4,
        spaceBetween: 20
      },
      1200: {
        slidesPerView: 5,
        spaceBetween: 30
      }
    };
    const selected = ref(vehicles[0].products);
    ref(null);
    const isClient = ref(false);
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<section${ssrRenderAttrs(mergeProps({ class: "section prod-selector" }, _attrs))}><div class="container !pb-11"><div class="prod-selector-header"><div class="section-header"><h2>\u0627\u0628\u062D\u062B \u0639\u0646 \u0627\u0644\u0628\u0637\u0627\u0631\u064A\u0629 \u0627\u0644\u0645\u0646\u0627\u0633\u0628\u0629 \u0644\u0633\u064A\u0627\u0631\u062A\u0643</h2></div></div></div><div id="product_container" class="product-container pt-11 min-h-[420px]">`);
      if (unref(selected).length) {
        _push(`<div class="product-swiper swiper-container">`);
        if (unref(isClient)) {
          _push(ssrRenderComponent(unref(Swiper), {
            centeredSlides: true,
            breakpoints: breakpoints1,
            dir: "rtl",
            freeMode: true,
            loop: true
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<!--[-->`);
                ssrRenderList(unref(selected), (product) => {
                  _push2(ssrRenderComponent(unref(SwiperSlide), {
                    key: product.sku
                  }, {
                    default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                      if (_push3) {
                        _push3(`<div class="prod-item"${_scopeId2}><div class="prod-img"${_scopeId2}><img${ssrRenderAttr("src", product.image)}${ssrRenderAttr("alt", product.title)}${_scopeId2}></div><div class="prod-meta"${_scopeId2}><h3${_scopeId2}><a${ssrRenderAttr("href", product.link)} target="_blank" rel="noopener noreferrer"${_scopeId2}>${ssrInterpolate(product.title)}</a></h3><p${_scopeId2}>${ssrInterpolate(product.sku)}</p></div><span class="prod-warranty"${_scopeId2}><img${ssrRenderAttr("src", product.warranty)} alt="Warranty"${_scopeId2}></span></div>`);
                      } else {
                        return [
                          createVNode("div", { class: "prod-item" }, [
                            createVNode("div", { class: "prod-img" }, [
                              createVNode("img", {
                                src: product.image,
                                alt: product.title
                              }, null, 8, ["src", "alt"])
                            ]),
                            createVNode("div", { class: "prod-meta" }, [
                              createVNode("h3", null, [
                                createVNode("a", {
                                  href: product.link,
                                  target: "_blank",
                                  rel: "noopener noreferrer"
                                }, toDisplayString(product.title), 9, ["href"])
                              ]),
                              createVNode("p", null, toDisplayString(product.sku), 1)
                            ]),
                            createVNode("span", { class: "prod-warranty" }, [
                              createVNode("img", {
                                src: product.warranty,
                                alt: "Warranty"
                              }, null, 8, ["src"])
                            ])
                          ])
                        ];
                      }
                    }),
                    _: 2
                  }, _parent2, _scopeId));
                });
                _push2(`<!--]-->`);
              } else {
                return [
                  (openBlock(true), createBlock(Fragment, null, renderList(unref(selected), (product) => {
                    return openBlock(), createBlock(unref(SwiperSlide), {
                      key: product.sku
                    }, {
                      default: withCtx(() => [
                        createVNode("div", { class: "prod-item" }, [
                          createVNode("div", { class: "prod-img" }, [
                            createVNode("img", {
                              src: product.image,
                              alt: product.title
                            }, null, 8, ["src", "alt"])
                          ]),
                          createVNode("div", { class: "prod-meta" }, [
                            createVNode("h3", null, [
                              createVNode("a", {
                                href: product.link,
                                target: "_blank",
                                rel: "noopener noreferrer"
                              }, toDisplayString(product.title), 9, ["href"])
                            ]),
                            createVNode("p", null, toDisplayString(product.sku), 1)
                          ]),
                          createVNode("span", { class: "prod-warranty" }, [
                            createVNode("img", {
                              src: product.warranty,
                              alt: "Warranty"
                            }, null, 8, ["src"])
                          ])
                        ])
                      ]),
                      _: 2
                    }, 1024);
                  }), 128))
                ];
              }
            }),
            _: 1
          }, _parent));
        } else {
          _push(`<!---->`);
        }
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></section>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/home/prod.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as _ };
//# sourceMappingURL=prod-dXiTk7BE.mjs.map
