import { mergeProps, unref, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrRenderAttr, ssrRenderStyle, ssrInterpolate } from 'vue/server-renderer';
import { b as useI18n } from './server.mjs';

const _sfc_main = {
  __name: "BattaryFeatures",
  __ssrInlineRender: true,
  setup(__props) {
    const { t } = useI18n();
    const breakpoints = {
      300: {
        slidesPerView: 2
      },
      600: {
        slidesPerView: 3
      },
      768: {
        slidesPerView: 4
      },
      992: {
        slidesPerView: 5
      },
      1200: {
        slidesPerView: 7
      }
    };
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "battery-features" }, _attrs))}><swiper-container${ssrRenderAttr("breakpoints", breakpoints)}${ssrRenderAttr("slides-per-view", 2)}><swiper-slide class="swiper-slide"><span class="icon"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 300 300" style="${ssrRenderStyle({ "enable-background": "new 0 0 300 300" })}" xml:space="preserve"><path d="m189.6 79.2-72.7 55.7c-1.6 1.2-2.3 3.2-1.9 5.1s1.8 3.5 3.7 4l18.9 5.6c.2 0 .2.2.4.4s0 .4 0 .4l-34 64.8c-.9 1.9-.5 4 1.1 5.4.9.7 1.8 1.1 2.8 1.1 1.1 0 1.9-.4 2.8-1.1l69.7-56.8c1.6-1.2 2.3-3.2 1.8-5.1-.4-1.9-1.8-3.5-3.7-4l-19.1-5.8s-.2 0-.2-.2v-.2L196 84.7c1.1-1.8.7-4-.9-5.4-1.6-1.3-3.7-1.3-5.5-.1zm-36.4 66.1c-1.1 1.9-1.2 4.2-.5 6.3.9 2.1 2.5 3.7 4.7 4.2l15.9 4.7-57.1 46.5 27.9-53.1c1.1-1.9 1.1-4.4.4-6.3-.9-2.1-2.6-3.7-4.7-4.2l-15.8-4.9 59.4-45.4-30.2 52.2z" style="${ssrRenderStyle({ "fill": "currentColor" })}"></path></svg></span><p>${ssrInterpolate(unref(t)("features.highCrankingPower"))}</p></swiper-slide><swiper-slide class="swiper-slide"><span class="icon"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 300 300" style="${ssrRenderStyle({ "enable-background": "new 0 0 300 300" })}" xml:space="preserve"><path d="M228.2 129.9h-12v-14.1c0-2.2-1.8-4-4-4H79.6c-2.2 0-4 1.8-4 4v68.3c0 2.2 1.8 4 4 4h132.5c2.2 0 4-1.8 4-4V170h12c2.2 0 4-1.8 4-4v-32.1c.1-2.2-1.7-4-3.9-4zm-78.3-10H174v60.2h-24.1v-60.2zm-8 60.2h-24.1v-60.2h24.1v60.2zm-58.3-60.2h26.1v60.2H83.6v-60.2zm124.5 60.2H182v-60.2h26.1v60.2zm16.1-18.1h-8v-24h8v24z" style="${ssrRenderStyle({ "fill": "currentColor" })}"></path></svg></span><p>${ssrInterpolate(unref(t)("features.highReserveCapacity"))}</p></swiper-slide><swiper-slide class="swiper-slide"><span class="icon"><svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" x="0" y="0" viewBox="0 0 300 300" style="${ssrRenderStyle({ "enable-background": "new 0 0 300 300" })}" xml:space="preserve"><path style="${ssrRenderStyle({ "fill": "currentColor", "stroke": "currentColor", "stroke-width": "3.3401", "stroke-miterlimit": "10" })}" d="M184.1 172.1c-.3 1.2.5 2.3 1.7 2.6 1.2.3 2.3-.5 2.6-1.7l4.6-21.9c.2-1.2-.5-2.3-1.6-2.6l-19.3-6.3 4.2-20c.2-1.2-.5-2.3-1.6-2.6l-19.3-6.3 4.2-20c.2-1.2-.5-2.3-1.6-2.6l-21-6.6c-1.1-.4-2.4.3-2.8 1.4-.4 1.1.3 2.4 1.4 2.8l19.4 6.3-4.2 19.8c-.3 1.1.3 2.3 1.4 2.7l.7-2.1-.7 2.1 19.4 6.3-4.2 19.8c-.3 1.1.3 2.3 1.4 2.7l.7-2.1-.7 2.1 19.4 6.3-4.1 19.9zM201.4 162.1c-.3 1.2.5 2.3 1.7 2.6 1.2.3 2.3-.5 2.6-1.7l4.6-21.9c.2-1.2-.5-2.3-1.6-2.6l-19.3-6.3 4.2-20c.2-1.2-.5-2.3-1.6-2.6l-19.3-6.3 4.2-20c.2-1.2-.5-2.3-1.6-2.6l-21.1-6.9c-1.1-.4-2.4.3-2.8 1.4-.4 1.1.3 2.4 1.4 2.8l19.4 6.3-4.2 19.8c-.3 1.1.3 2.3 1.4 2.7l.7-2.1-.7 2.1 19.4 6.3-4.2 19.8c-.3 1.1.3 2.3 1.4 2.7l.7-2.1-.7 2.1 19.4 6.3-4 20.2zM163 215.9c1.1.4 2.4-.3 2.8-1.4.4-1.1-.3-2.4-1.4-2.8l-19.4-6.3 4.2-20c.2-1.2-.5-2.3-1.6-2.6l-19.3-6.3 4.2-20c.2-1.2-.5-2.3-1.6-2.6l-19.3-6.3 4.2-20c.3-1.2-.5-2.3-1.7-2.6-1.2-.3-2.3.5-2.6 1.7l-4.6 21.7c-.3 1.1.3 2.3 1.4 2.7l.7-2.1-.7 2.1 19.4 6.3-4.2 19.8c-.3 1.1.3 2.3 1.4 2.7l.7-2.1-.7 2.1 19.4 6.3-4.2 19.8c-.3 1.1.3 2.3 1.4 2.7l.7-2.1-.7 2.1 21.5 7.2zM145.7 225.9c1.1.4 2.4-.3 2.8-1.4.4-1.1-.3-2.4-1.4-2.8l-19.4-6.3 4.2-20c.2-1.2-.5-2.3-1.6-2.6l-19.3-6.3 4.2-20c.2-1.2-.5-2.3-1.6-2.6l-19.3-6.3 4.2-20c.3-1.2-.5-2.3-1.7-2.6-1.2-.3-2.3.5-2.6 1.7l-4.6 21.7c-.3 1.1.3 2.3 1.4 2.7l.7-2.1-.7 2.1 19.4 6.3-4.2 19.8c-.3 1.1.3 2.3 1.4 2.7l.7-2.1-.7 2.1 19.4 6.3-4.2 19.8c-.3 1.1.3 2.3 1.4 2.7l.7-2.1-.7 2.1 21.5 7.2z"></path></svg></span><p>${ssrInterpolate(unref(t)("features.vibrationResistance"))}</p></swiper-slide><swiper-slide class="swiper-slide"><span class="icon"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 300 300" style="${ssrRenderStyle({ "enable-background": "new 0 0 300 300" })}" xml:space="preserve"><path d="M94.9 82.4c1.4-1.4 3.5-1.7 5.3-.9L125.1 94c1.6.8 2.5 2.4 2.5 4.1v10.6l8.7 8.7c1.1-8.8 5.1-17.3 11.9-24.1C161 80.5 180 77.7 195.4 85c1.3.6 2.3 1.9 2.6 3.4.3 1.5-.2 3-1.3 4l-21.4 21.4 10.8 10.8 21.4-21.4c1.1-1.1 2.6-1.5 4-1.3 1.5.3 2.7 1.2 3.4 2.6 7.3 15.4 4.5 34.4-8.3 47.2-3.4 3.4-7.2 6.1-11.3 8.1l16.2 16.2c9.8 9.8 9.8 25.8 0 35.6s-25.8 9.8-35.6 0l-24.9-25c-1.5-1.5-2.7-3-3.7-4.7l-31 31c-8.1 8.1-21.1 8.1-29.2 0-8.1-8.1-8.1-21.1 0-29.2l38.8-38.8-17.2-17.2H98.1c-1.7 0-3.3-1-4.1-2.5l-12.5-24.9c-.9-1.8-.5-3.9.9-5.3l12.5-12.6zm37.5 56 5-5c-.2-.8-.4-1.6-.6-2.5l-17-17c-.9-.9-1.3-2-1.3-3.2V101L99 91.3 91.3 99l9.7 19.4h9.6c1.2 0 2.4.5 3.2 1.3l18.6 18.7zm21.7 36.7c.8 1.8 1.9 3.5 3.4 5l24.9 24.9c6.2 6.2 16.4 6.2 22.6 0 6.2-6.2 6.2-16.4 0-22.6L185.6 163c-6.3 1.3-12.8 1.1-19-.5l-12.5 12.6zm.7-75.3c8.2-8.2 19.8-11.1 30.3-8.7l-19.5 19.5c-.9.9-1.3 2-1.3 3.2 0 1.2.5 2.4 1.3 3.2l17.3 17.3c1.8 1.8 4.7 1.8 6.5 0l19.5-19.5c2.4 10.5-.5 22.1-8.7 30.3-9.1 9.1-22.1 11.7-33.4 7.8-1.7-.6-3.5-.1-4.7 1.1l-52.3 52.3c-4.5 4.5-11.7 4.5-16.2 0s-4.5-11.7 0-16.2l52.3-52.3c1.2-1.2 1.7-3.1 1.1-4.7-3.9-11.2-1.3-24.2 7.8-33.3z" style="${ssrRenderStyle({ "fill-rule": "evenodd", "clip-rule": "evenodd", "fill": "currentColor" })}"></path></svg></span><p>${ssrInterpolate(unref(t)("features.zeroMaintenance"))}</p></swiper-slide><swiper-slide class="swiper-slide"><span class="icon"><svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" x="0" y="0" viewBox="0 0 300 300" style="${ssrRenderStyle({ "enable-background": "new 0 0 300 300" })}" xml:space="preserve"><path style="${ssrRenderStyle({ "fill": "currentColor" })}" d="M150 221.8c-1.1 0-2.2-.3-3.2-1-52.4-36.3-56.5-71.6-56.5-113.9 0-2.7 1.9-5 4.5-5.5 28.4-5.4 51.7-21.9 51.9-22.1 1.9-1.4 4.6-1.4 6.5 0 .2.2 23.5 16.6 51.9 22.1 2.6.5 4.5 2.8 4.5 5.5 0 42.4-4.2 77.7-56.5 113.9-.9.6-2 1-3.1 1zm-48.5-110.4c.3 38.4 5.1 66.7 48.5 97.9 43.4-31.2 48.2-59.6 48.5-97.9-22.7-5.2-41.3-16.1-48.5-20.8-7.3 4.7-25.8 15.5-48.5 20.8z"></path><path style="${ssrRenderStyle({ "fill": "currentColor" })}" d="M143.3 173.2c-1.8 0-3.6-.7-5-2l-18.7-18.4c-2.8-2.8-2.9-7.3-.1-10.1s7.3-2.9 10.1-.1l13.7 13.4 27.2-27.2c2.8-2.8 7.3-2.8 10.1 0s2.8 7.3 0 10.1l-32.2 32.2c-1.5 1.4-3.3 2.1-5.1 2.1z"></path></svg></span><p>${ssrInterpolate(unref(t)("features.improvedSafety"))}</p></swiper-slide><swiper-slide class="swiper-slide"><span class="icon"><svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" x="0" y="0" viewBox="0 0 300 300" style="${ssrRenderStyle({ "enable-background": "new 0 0 300 300" })}" xml:space="preserve"><path style="${ssrRenderStyle({ "fill": "currentColor" })}" d="M161.5 165.7V97.2c0-12.1-9.8-21.9-21.9-21.9s-21.9 9.8-21.9 21.9v68.5c-7.4 6.4-11.7 15.7-11.7 25.4 0 18.5 15 33.6 33.6 33.6s33.6-15 33.6-33.6c0-9.7-4.2-19-11.7-25.4zm-21.9 50.2c-13.7 0-24.8-11.1-24.8-24.8 0-7.8 3.7-15.2 9.9-19.8 1.1-.8 1.8-2.1 1.8-3.5V97.2c0-7.3 5.9-13.1 13.1-13.1 7.3 0 13.1 5.9 13.1 13.1v70.6c0 1.4.6 2.7 1.8 3.5 11 8.2 13.2 23.8 5 34.7-4.7 6.3-12.1 9.9-19.9 9.9z"></path><path style="${ssrRenderStyle({ "fill": "currentColor" })}" d="M144 175.7V97.5c0-2.4-2-4.4-4.4-4.4s-4.4 2-4.4 4.4v78.2c-8.5 2.4-13.5 11.3-11.1 19.8 2.4 8.5 11.3 13.5 19.8 11.1 8.5-2.4 13.5-11.3 11.1-19.8-1.4-5.4-5.6-9.6-11-11.1zm-4.4 22.7c-4 0-7.3-3.3-7.3-7.3s3.3-7.3 7.3-7.3 7.3 3.3 7.3 7.3c0 4.1-3.2 7.3-7.3 7.3zM177.6 101.9h12c2.4 0 4.4-2 4.4-4.4s-2-4.4-4.4-4.4h-12c-2.4 0-4.4 2-4.4 4.4s2 4.4 4.4 4.4zM189.5 110.6h-12c-2.4 0-4.4 2-4.4 4.4 0 2.4 2 4.4 4.4 4.4h12c2.4 0 4.4-2 4.4-4.4 0-2.4-1.9-4.4-4.4-4.4zM189.5 128.1h-12c-2.4 0-4.4 2-4.4 4.4s2 4.4 4.4 4.4h12c2.4 0 4.4-2 4.4-4.4s-1.9-4.4-4.4-4.4zM189.5 145.6h-12c-2.4 0-4.4 2-4.4 4.4s2 4.4 4.4 4.4h12c2.4 0 4.4-2 4.4-4.4s-1.9-4.4-4.4-4.4z"></path></svg></span><p>${ssrInterpolate(unref(t)("features.highHeatTolerance"))}</p></swiper-slide><swiper-slide class="swiper-slide"><span class="icon"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 300 300" style="${ssrRenderStyle({ "enable-background": "new 0 0 300 300" })}" xml:space="preserve"><path d="m125.2 1030.5-5.4 16.1-17.7 52.9c-17.9 0-23.1-.1-43.3-.1v9.3c21.8 0 24.9.1 46.7.1h3.4l1.1-3.2 13.3-39.9 19.7 90.8 3.9 17.5 5.2-17.2 22-71.9 9 21 1.2 2.8h3.1l36.3-.1c1.6 2.8 4.6 4.7 8.1 4.7 5.2 0 9.3-4.2 9.3-9.3 0-5.2-4.2-9.3-9.3-9.3-3.4 0-6.4 1.8-8 4.6l-33.2.1-12.9-29.9-5-11.7-3.7 12.2-20.4 67-19.6-90-3.8-16.5z" style="${ssrRenderStyle({ "fill": "currentColor" })}" transform="translate(0 -952.362)"></path></svg></span><p>${ssrInterpolate(unref(t)("features.longLife"))}</p></swiper-slide></swiper-container></div>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/home/BattaryFeatures.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as _ };
//# sourceMappingURL=BattaryFeatures-D-xcoAw-.mjs.map
