"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const index_1 = __importDefault(require("./routes/web/index"));
const index_2 = __importDefault(require("./routes/admin/index"));
const general_1 = __importDefault(require("./routes/general"));
const admin_1 = __importDefault(require("./routes/auth/admin"));
const jwtMiddleware_1 = require("./src/middleware/jwtMiddleware");
const helmet_1 = __importDefault(require("helmet"));
const compression_1 = __importDefault(require("compression"));
const multer_1 = __importDefault(require("multer"));
const database_1 = __importDefault(require("./utils/database"));
const path_1 = __importDefault(require("path"));
const cors_1 = __importDefault(require("cors"));
// import multer from "multer"
// import { auth } from 'express-openid-connect'
// import config from "./src/config/index"
const dotenv_1 = __importDefault(require("dotenv"));
const errorHandler_1 = require("./src/middleware/errorHandler");
dotenv_1.default.config();
const app = (0, express_1.default)();
app.use((0, cors_1.default)({
    origin: "*",
    methods: ["GET", "POST", "PUT", "DELETE", "PATCH"],
    // credentials: true,
    // allowedHeaders: ["Content-Type", "Authorization"],
}));
app.use((0, helmet_1.default)({
    contentSecurityPolicy: {
        directives: {
            defaultSrc: ["'self'"], // Self domain
            connectSrc: ["'self'", "https://backend.najidalqimam.sa"],
            imgSrc: ["'self'", "https://backend.najidalqimam.sa"],
            mediaSrc: ["'self'", "https://backend.najidalqimam.sa"],
            scriptSrc: ["'self'"], // Self scripts only
            objectSrc: ["'none'"], // No plugins or Flash
            upgradeInsecureRequests: [], // Force HTTP to HTTPS
        },
    },
    crossOriginResourcePolicy: { policy: "cross-origin" }, // Allow cross-origin images/media if needed
}));
app.use((0, compression_1.default)());
app.use(express_1.default.json());
app.use(express_1.default.urlencoded({ extended: true }));
app.set("trust proxy", true);
const PORT = 3002;
app.use(express_1.default.static(path_1.default.join(__dirname, "public")));
app.use("/images", express_1.default.static("public/storage/images"));
app.use("/files", express_1.default.static("public/storage/files"));
// app.use(express.urlencoded({ extended: true }));
const apiRouter = express_1.default.Router();
apiRouter.use("/web", index_1.default);
apiRouter.use("/admin/auth", (0, multer_1.default)().any(), admin_1.default);
apiRouter.use("/admin", (0, multer_1.default)().none(), jwtMiddleware_1.authenticateToken, index_2.default);
apiRouter.use("/general", general_1.default);
app.use("/api", apiRouter);
app.use(errorHandler_1.errorHandler);
database_1.default
    .sync({
// force: false, // Set true to drop table and create new one each time.
// logging: false, // Set to true to log all SQL queries.
})
    .then((res) => {
    app.listen({
        port: PORT,
        host: "0.0.0.0",
        env: process.env.NODE_ENV || "development",
    });
})
    .catch((err) => console.log(err));
