"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.contactsIndex = void 0;
const responseHandler_1 = require("../../../utils/responseHandler");
const contacts_1 = __importDefault(require("../../models/contacts"));
const contactsIndex = async (req, res) => {
    try {
        const allContacts = await contacts_1.default.findAll();
        responseHandler_1.ResponseHandler.success(res, allContacts);
    }
    catch (error) {
        if (error instanceof Error) {
            responseHandler_1.ResponseHandler.error(res, error.message ?? "Failed to fetch settings", 500);
        }
        else {
            responseHandler_1.ResponseHandler.error(res, "Failed to fetch settings", 500);
        }
    }
};
exports.contactsIndex = contactsIndex;
