"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.newsIndex = void 0;
const responseHandler_1 = require("../../../utils/responseHandler");
const news_letters_1 = __importDefault(require("../../models/news_letters"));
const newsIndex = async (_req, res) => {
    try {
        const allContacts = await news_letters_1.default.findAll({
            attributes: ["id", "email"],
        });
        responseHandler_1.ResponseHandler.success(res, allContacts);
    }
    catch (error) {
        if (error instanceof Error) {
            responseHandler_1.ResponseHandler.error(res, error.message ?? "Failed to fetch settings", 500);
        }
        else {
            responseHandler_1.ResponseHandler.error(res, "Failed to fetch settings", 500);
        }
    }
};
exports.newsIndex = newsIndex;
