"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.settingIndex = exports.createSettings = void 0;
// import sequelize from "../../../utils/database"
const responseHandler_1 = require("../../../utils/responseHandler");
const settings_1 = __importDefault(require("../../models/settings"));
const createSettings = async (req, res) => {
    try {
        const { ...keys } = req.body;
        for (const [key, value] of Object.entries(keys)) {
            const setting = await settings_1.default.findOne({ where: { key } });
            if (setting) {
                await setting.update({ value });
            }
            else {
                await settings_1.default.create({ key, value });
            }
        }
        const allSettings = await settings_1.default.findAll();
        const response = allSettings.reduce((acc, setting) => {
            acc[setting.key] = setting.value;
            return acc;
        }, {});
        responseHandler_1.ResponseHandler.success(res, response);
    }
    catch (error) {
        if (error instanceof Error) {
            responseHandler_1.ResponseHandler.error(res, error.message ?? "Failed to create or update settings", 500);
        }
        else {
            responseHandler_1.ResponseHandler.error(res, "Failed to create or update settings", 500);
        }
    }
};
exports.createSettings = createSettings;
const settingIndex = async (req, res) => {
    try {
        const allSettings = await settings_1.default.findAll();
        // const response = allSettings.reduce((acc, setting) => {
        //     acc[setting.key] = setting.value;
        //     return acc;
        // }, {} as Record<string, string | number>);
        responseHandler_1.ResponseHandler.success(res, allSettings);
    }
    catch (error) {
        if (error instanceof Error) {
            responseHandler_1.ResponseHandler.error(res, error.message ?? "Failed to fetch settings", 500);
        }
        else {
            responseHandler_1.ResponseHandler.error(res, "Failed to fetch settings", 500);
        }
    }
};
exports.settingIndex = settingIndex;
