"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createNews = exports.createContact = void 0;
const responseHandler_1 = require("../../../utils/responseHandler");
const contacts_1 = __importDefault(require("../../models/contacts"));
const news_letters_1 = __importDefault(require("../../models/news_letters"));
const createContact = async (req, res) => {
    try {
        const { name, email, phone, country, city, postal_code, type } = req.body;
        console.log(name, email, phone, country, city, postal_code, type);
        const contacts = await contacts_1.default.create({
            name,
            email,
            phone,
            country,
            city,
            postal_code,
            type,
        });
        responseHandler_1.ResponseHandler.success(res, contacts.get(), "تم الارسال بنجاح");
    }
    catch (err) {
        res
            .status(422)
            .json({ message: err instanceof Error ? err.message : "حدث خطأ ما" });
        return;
    }
};
exports.createContact = createContact;
const createNews = async (req, res) => {
    try {
        const { email } = req.body;
        const news = await news_letters_1.default.create({ email });
        responseHandler_1.ResponseHandler.success(res, news.get(), "Subscribe successfully");
    }
    catch (err) {
        res.status(422).json({ message: "Invalid request data" });
        return;
    }
};
exports.createNews = createNews;
